(function($){

BEM.DOM.decl('b-checkboxes-group', {
    onSetMod: {
        'js': function(){
            this.name = this.params.name;
            BEM.blocks['b-checkboxes-group'].on('refresh', this.refreshHash, this);
            this.refreshHash({}, 1);

        }
    },

    refreshHash: function(e, isFirst) {
        var _this = this;


        this.singleCbxs = $.map(_this.name ? _this.findElem('cbx', 'name', _this.name) : _this.findElem('cbx'), function(elem) {
            //val не возвращает this!!!
            var cbx = _this.findBlockInside($(elem), 'b-form-checkbox');
            if (cbx) {
                cbx.on('change', function() {
                    _this.toggleOne.call(_this, this);
                });
                cbx.val(_this.getMod($(elem), 'val'));
            }
            return cbx;

        });
        !isFirst && this.trigger('change', {mode: 'all'});
    },

    toggleOne: function(bemElem) {
        this.trigger('change', { checked: bemElem.getMod('checked') == 'yes', value:bemElem.val(), elem: bemElem.domElem});
        this.updateHidden();
    },

    toggleAll: function() {
        this.updateHidden();
    },

    updateHidden: function() {
        this.elem('hidden').length && this.elem('hidden').val(this.getChecked().join(','));
    },

    setChecked: function(checked) {
        return $.map(this.singleCbxs, function (cbx) {
            if ($.inArray(cbx.val(), checked) != -1) {
                cbx.setMod('checked', 'yes');
            }
        });
    },

    getChecked: function() {
        return $.map(this.singleCbxs, function (cbx) {
           if ( cbx.getMod('checked') == 'yes') {
               return cbx.val();
           }
        });
    },

    isEmpty: function() {
        return !this.singleCbxs || this.singleCbxs.length == 0;
    },

    getCommonState: function() {
        var checked = true;
        $.map(this.singleCbxs, function (cbx) {
            checked = checked && cbx.getMod('checked') == 'yes'
        });
        return checked;
    },

    setAllState: function(checked) {
        $.map(this.singleCbxs, function (cbx) {
            cbx.setMod('checked', checked);
        });
    }



});

})(jQuery);
