(function($) {
    BEM.DOM.decl('b-child-food-label', {
        onSetMod : {
            js: function() {

                this.cachedAge = this.params.age || 11;

                this.model =  BEM.blocks['i-models-manager'].get(this.params.modelPath, 'b-banner-edit')
                    .onField('child_age', 'change', this.onExternalChange, this);

                this.popup = this.findBlockInside('b-dropdowna').getPopup();
                this.displayLabel = this.findBlockInside('dropdown', 'b-pseudo-link').domElem;

                request = BEM.create('i-request_type_ajax', {
                    url: '/registered/main.pl',
                    cache: false,
                    dataType: 'json',
                    onError: function () {
                        alert('Ошибка соединения с сервером');
                    }
                });

                this
                    .bindTo('item', 'click', function(e) {
                        var age = +this.findBlockInside(e.data.domElem, 'b-pseudo-link').params.age;

                        if (age != this.cachedAge)
                            this.setAge(age);

                        this.popup.hide();
                    });
            }
        },

        _onSaveAge: function(age) {
            var displayAge = age + ' ' + common.inflector.pluralizeWord(['месяца', 'месяцев', 'месяцев'], age);

            this.displayLabel
                .text(displayAge)
                .attr('title', displayAge);
        },

        onExternalChange: function(e, data) {
            if (data.source == this) return;

            this._onSaveAge(this.model.get('child_age'));
        },

        /*
        * Установка возрастного ограничения
        * @param {Number} age Возраст.
        */
        setAge: function(age) {
            this.cachedAge = age;

            this.model.set('child_age', age, this);

            request.get({
                    cmd: 'changeFlagsAjax',
                    bid: this.params.bid,
                    flag: 'baby_food=' + age,
                    csrf_token: window.csrf_token
                }, function (result) {
                    this._onSaveAge(age);
                    if (result && result.success) {
                        this._onSaveAge(age);
                    } else {
                        alert('Ошибка соединения с сервером');
                    }
                },
                {
                    callbackCtx: this
                }
            );
        }
    });

    BEM.HTML.decl('b-child-food-label', {

        onBlock: function(ctx) {
            var age = ctx.param('age'),
                variants = [12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0],
                variantsContent = [],
                displayAge = age + ' ' + common.inflector.pluralizeWord(['месяца', 'месяцев', 'месяцев'], age);

            //age может быть равен 0!
            if (typeof age == 'undefiend')
                age = 11;

            /*
            Создаем контент с элементами b-menu, которые будут в b-dropdown
            b-menu в тт2 неправильно строится, поэтому тут хаки и много лишних оберток
            TODO После нормализации b-menu поправить здесь элементы
            */
            for (var i = 0; i < variants.length; i++)
                variantsContent.push({
                    elem: 'layout-vert-cell',
                    tag: 'li',
                    content: {
                        block: 'b-pseudo-link',
                        mix: [ { block: 'b-child-food-label', elem: 'item' } ],
                        js: { age: variants[i] },
                        content: variants[i] + ' ' + common.inflector.pluralizeWord(['месяца', 'месяцев', 'месяцев'], variants[i])
                    }
                });

            ctx
                .js({
                    age: ctx.param('age'),
                    bid: ctx.param('bid')
                })
                .content([
                    'Проконсультируйтесь со специалистом. Для питания детей с ',
                    {
                        block: 'b-dropdowna',
                        mix: [ { block: 'b-child-food-label', elem: 'dropdown' } ],
                        content: [
                            {
                                block: 'b-dropdowna',
                                elem: 'switcher',
                                tag: 'span',
                                content: {
                                    block: 'b-pseudo-link',
                                    mods: {'is-bem' : 'yes'},
                                    content: displayAge
                                }
                            },
                            {
                                block: 'b-popupa',
                                mods: {'is-bem' : 'yes'},
                                mix: [{ block: 'b-dropdowna', elem: 'popup' }],
                                content: [
                                    { elem: 'tail' },
                                    {
                                        elem: 'content',
                                        content: {
                                            block: 'b-menu',
                                            mods: { layout: 'vert', preset: 'vmenu' },
                                            content: {
                                                elem: 'layout-vert',
                                                tag: 'ul',
                                                content: variantsContent
                                            }
                                        }
                                    }
                                ]
                            }
                        ]
                    },
                    '.'
                ]);
        }

    });
})(jQuery);
