(function($){
    var iModelsManager = BEM.blocks['i-models-manager'],
        request;

    BEM.DOM.decl('b-child-food-labels-multiedit', {
        onSetMod: {
            'js': function(){
                var _this = this;

                this.popupa = this.findBlockOutside('b-popupa');
                this.cancelBtn = this.findBlockInside('cancel', 'b-form-button')
                    .on('click', this.onCancel, this);

                this.acceptBtn = this.findBlockInside('accept', 'b-form-button')
                    .on('click', this.onAccept, this);

                this.models = [];
                this.bids = [];

                $.each(this.params.bids, function(i, bid){
                    var model = iModelsManager.get('campaign&banner:' + bid, 'b-banner-edit');

                    if (model.get('baby_food_enabled')) {
                        _this.models.push(model);
                        _this.bids.push(bid);
                    }
                });

                request = BEM.create('i-request_type_ajax', {
                    cache: false,
                    url: '/registered/main.pl',
                    dataType: 'json',
                    callbackCtx: this,
                    type: 'post'
                });
            }
        },

        onCancel: function() {
            this.popupa.hide();
        },

        onAccept: function() {
            var age = this.elem('radio:checked').val(),
                pids = this.models.map(function(model) {
                    return model.get('pid');
                });

            request.get(
                {
                    cmd: 'changeGroupFlagsAjax',
                    pid: pids.join(','),
                    flag: 'baby_food=' + age
                },
                function() {
                    $.each(this.models, function(i, model) {
                        model.set('child_age', age, this);
                    });

                    this.popupa.hide();
                }
            );
        }
    });

    BEM.HTML.decl('b-child-food-labels-multiedit', {

        onBlock: function(ctx){
            ctx
                .js(true)
                .content({ elem: 'form', cid: ctx.param('cid'), bids: ctx.param('bids') });
        },

        onElem: {

            'form': function(ctx){
                ctx
                    .content(
                    [
                        {
                            tag: 'h2', content:
                            [
                                {
                                    tag: 'span',
                                    content: iget('Изменить возрастное<br/> ограничение')
                                }
                            ]
                        },
                        {
                            tag: 'div',
                            elem: 'comment',
                            content:  iget('Изменение будет применено только к объявлениям с доступным возрастным ограничением')
                        },

                        {
                            tag: 'div',
                            elem: 'comment',
                            content:  iget('Выбрано объявлений') + ': ' + ctx.param('bids').length
                        }


                    ]
                        .concat(
                        $.map(['cid', 'bids'], function(el){
                            return { tag: 'input', attrs: { type: 'hidden', name: el, value: ctx.param(el) } }
                        }),
                        { elem: 'container' },
                        { elem: 'errors' },
                        { elem: 'accept' }, { elem: 'cancel' }
                    )
                )
            },

            'container': function(ctx) {
                //todo прокинуть AD_WARNINGS.baby_age.variants
                var content = [];
                $.each([12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0], function(i, age) {
                    content.push({
                        elem: 'age-item',
                        content: [
                            {
                                tag: 'input',
                                attrs: {'type': 'radio', value: age, id: 'age_multiedit_' + age, name: 'age_multiedit'},
                                elem: 'radio'
                            },
                            {
                                tag: 'label',
                                content: age + ' ' + common.inflector.pluralizeWord(['месяц', 'месяца', 'месяцев'], age),
                                elem: 'label',
                                attrs: {'for': 'age_multiedit_' + age}
                            }
                        ]
                    })
                });

                ctx.content(content);
            },

            'accept': function(ctx){
                ctx
                    .tag('span')
                    .content({
                        block: 'b-form-button',
                        mods: { valign: 'middle' },
                        type: 'button',
                        content: iget('Сохранить')
                    })
            },
            'cancel': function(ctx){
                ctx
                    .tag('span')
                    .content({
                        block: 'b-form-button',
                        mods: { valign: 'middle' },
                        type: 'button',
                        content: iget('Отмена')
                    })
            }
        }

    });


})(jQuery);
