(function($){

BEM.DOM.decl('b-choose-clients-for-transfer', {
    onSetMod: {
        'js': function(){
            var selectFrom = this.elem('from-select'),
                selectTo = this.elem('to-select');

            this
                .bindTo(selectFrom, 'change', function() {
                    var currentCurrency = this.getMod(this.elem('client-opt-from').eq(selectFrom.prop('selectedIndex')), 'currency');

                    // сначала прячем все, потом показываем только те, которые в валюте выбранного клиента
                    // т. к. стили для option-ов много где не работают, прятать приходится перемещением, а не display: none;
                    this.elem('hidden-storage').html(this.elem('client-opt-to'));
                    selectTo.html(this.elem('client-opt-to', 'currency', currentCurrency));

                    this.updateSubmitButtonState();
                    this.setMod('currency', currentCurrency);
                })
                .bindTo(selectTo, 'change', this.updateSubmitButtonState)
                .bindTo('form', 'submit', function() {
                    return selectFrom.attr('selectedIndex') < 0 || selectTo.attr('selectedIndex') < 0 ?
                        !!alert(iget('Клиенты не выбраны')) :
                        true;
                });
        }
    },
    updateSubmitButtonState: function() {
        var selectFrom = this.elem('from-select'),
            selectTo = this.elem('to-select'),
            button = this.findBlockOn('button', 'b-form-button');

        button.setMod('disabled', (selectFrom.val() && selectTo.val()) ? '' : 'yes');
    }
}, {});

})(jQuery);
