/**
 * Created by JetBrains WebStorm.
 * User: collapsus
 * Date: 9/14/11
 * Time: 12:32 PM
 * To change this template use File | Settings | File Templates.
 */
(function($, Lego) {
    Lego.block['b-choose-currency'] = function(params) {
        var $this = $(this),
            $doc = $(document),
            select = $('.b-choose-currency__select', $this),
            text = $('.b-choose-currency__text', $this),
            hidden = $('.b-choose-currency__currency-hidden', $this),
            isClientMake = params.clientMake,
            country_hidden = $('.b-choose-country__country-hidden', $doc),
            cC = params.countriesCurrencies;

        $doc
            .bind('b-choose-currency.change_currency', function(e, currency){ hidden.val(currency) })
            .bind('b-choose-country.country_changed', function(e, val, init){
                if (val) {
                    if (!cC[val]) {
                        val = "other";
                    }
                    var hasOwnCurrency = (cC[val] && cC[val].length == 1);

                    text
                        .addClass('g-common__bold')
                        .toggleClass('g-hidden', !hasOwnCurrency).html(hasOwnCurrency ? cC[val][0].title : '');

                    if (!hasOwnCurrency) {
                        $('option:gt(0)', select).remove(); // удаляем все варианты, кроме "Выберите из списка..."
                        $.each(cC[val], function(index, currency) {
                            select.append($('<option></option>').val(currency.code).text(currency.title));
                        });
                    }

                    select.css('visibility', hasOwnCurrency ? 'hidden' : 'visible').val('');
                } else
                    text
                        .removeClass('g-common__bold')
                        .html(
                            '<span class="g-common__disabled">' +
                                (isClientMake ?
                                    iget('пожалуйста, выберите страну клиента') :
                                    iget('пожалуйста, укажите из какой вы страны')) +
                            '</span>');

                var newCurrency = (val && hasOwnCurrency) ? cC[val][0].code : (init ? hidden.val() : '');
                $doc.trigger('b-choose-currency.change_currency', [newCurrency, !!val || !init]);
            })
            .trigger('b-choose-country.country_changed', [country_hidden.val(), true]); // первоначальная отрисовка слов 'пожалуйста укажите из какой вы страны'

        select
            .val(hidden.val()) // выставляем селект на валюту проброшенную в параметрах DIRECT-20340
            .change(function(){ $doc.trigger('b-choose-currency.change_currency', [this.value, true]) });

    };
})(jQuery, window.Lego);
