include('../../js/jq/common/format.js');

(function($, Lego) {
    
var format = common.format,
    listTable = Lego.block['b-list-table'];

Lego.block['b-client-list'] = function(params) {
    var $this = $(this),
        list  = params.list,         // searchable
        input = params.input,        // чьи события слушать
        rows  = [],                  // пререндеренные строчки по которым будет вестись поиск
        lastQuery = '',              // предыдущее значение
        hltBlocks = [],
        //
        // massActionHelpers: хелперы для массовых операций, дополняют имеющийся
        // у b-list-table "недоделанный" интерфейс.
        //
        // интерфейсы методов зафиксированы в b-list-table, scope нигде явно не фиксируется
        // 
        massActionHelpers = {
            notifyItemsWithoutAction: function(withoutAction, params) {
                var items = [],
                    item;
                
                for (var i = 0, j = withoutAction.length; i < j; i++) {
                    item = params.actionsInfo[withoutAction[i]];
                    items[i] = item.login;
                }
                
                var text = iget('Выбранное действие недоступно для клиентов: ')
                    + items.join(', ')
                    + '\n'
                    + iget("Продолжить?");

                return confirm(text);
            },
            
            notifyTooManyActions: function(withAction) {
                if (withAction.length > 100) {
                    alert(iget('Нельзя выполнить действие более чем со 100 клиентами.'));
                    return false;
                }
                
                return true;
            },
            
            submitForm: function(action, withAction, params) {
                function appendInput(name, val) {
                    $('<input/>')
                        .attr({
                            name: name,
                            value:  val,
                            type: 'hidden'
                        })
                        .appendTo($form);
                }
                
                var $form = $('<form/>').attr({
                    action: location.href.replace(/\?.*/, ''),
                    method: 'get'
                });
                
                appendInput('cmd', action);
                
                for (var i = 0, j = withAction.length; i < j; i++) {
                    appendInput('client_login', params.actionsInfo[withAction[i]].login);
                }
                
                if (params.ulogin) {
                    appendInput('ulogin', params.ulogin);
                }
                
                if (action == 'showSubClientCamps') {
                    appendInput('stat_type', 'by_agency_clients');
                }
                
                if (action == 'showCampStat') {
                    appendInput('stat_type', params.statType);
                }
                
                if (action == 'archiveUser' || action == 'unArchiveUser') {
                    appendInput('cl_cnt', params.actionsInfo.length - withAction.length); // кол-во клиентов которые остались (для редиректа)
                    
                    if (window.Direct_cmd) {
                        appendInput('rcmd', window.Direct_cmd);
                    }
                    
                    if (params.agencyClientList) {
                        appendInput('agency_client_list', params.agencyClientList);
                    }
                }
                
                if (window.csrf_token) {
                    appendInput('csrf_token', window.csrf_token);
                }
                
                $form
                    .appendTo('body')
                    .submit();
            }
           
        },
        $selContainer = $this.find('.b-client-list__selectors'),
        ua = navigator.userAgent.toLowerCase(), // для фикса бага в сафари с отрисовкой таблицы
        isChrome = (/chrome/).test(ua), //
        isSafari = !isChrome && (/safari/).test(ua); //
        
    // инициализация описаний
    listTable.initDescriptions(this);
    // инициализация массовых действий
    listTable.initMassActions(this, massActionHelpers);

    $('tbody tr', this).each(function() {
        if (this.className.indexOf('b-client-list__child') != -1) {
            rows[rows.length - 1].children.push(this);
        } else if (this.className.indexOf('b-client-list__separator') != -1) {
            rows[rows.length - 1].group.push(this);
        } else {
            $(this).data(
                'client-list', 
                rows[rows.length] = {
                    node: $(this),
                    children: [],
                    group: [this],
                    rowspan: $('.b-client-list__rowspan', this),
                    toggle: $('.b-client-list__togle-children', this),
                    index: rows.length,
                    description: $('.description', this),
                    pos: $('.pos', this)
                }
            );
        }
    });
        
    list.chunkSize    = 10;
    list.chunkTimeout = 42;
    
    setTimeout(function() { listTable.fixWidths($this); }, isSafari ? 420 : 42); // фикс бага в сафари, при котором фиксирование размеров таблицы происходило слишком рано, в итоге немного корявая вёрстка

    $('.b-client-list__togle-children', $this).bind('click', function() {
        var tr = $(this).closest('tr'),
            data = tr.data('client-list');
            
        if (data.children[0].style.display == 'none') {
            $(data.children).show();
            this.src = '/i/hide.gif';
            data.rowspan.attr('rowspan', data.children.length + 1);
//            $this.removeClass('b-list-table_fixed')
        } else {
            $(data.children).hide();
            this.src = '/i/show.gif';
            data.rowspan.attr('rowspan', 1);
        }
    });

    list.bind('search.found', function(item, iterator) {
        var row = rows[iterator.iteration];
        iterator.visible.push(iterator.iteration);
        if (iterator.empty || iterator.visible.length < 100) {
            showParent(row);
            row.toggle.attr('src', '/i/show.gif');
            row.rowspan.attr('rowspan', 1);
            row.pos.html(iterator.visible.length);
            highlight(row, iterator);
        } else {
            hideRow(row);
        }
    });
    
    list.bind('search.missed', function(item, iterator) {
        hideRow(rows[iterator.iteration]); // direct access is much (> 10x) faster
        // rows[iterator.iteration].group.hide();
        // rows[iterator.iteration].children.hide();
    });
    
    list.bind('search.start', function(iterator) {
        iterator.regexp = new RegExp('(' + iterator.query.text.replace(/(.)/g, '[$1]') + ')', 'i');
        iterator.visible = [];
        iterator.empty = !iterator.query.text.match(/\S/);
        if (!iterator.empty) $this.addClass('b-list-table_fixed');
        $(params.eventTarget).triggerHandler('search_start');
    });
    
    list.bind('search.finish', function(iterator) {
        $('.b-list-table__empty', $this)[iterator.visible.length > 0 ? 'hide' : 'show']();
        $(params.eventTarget).triggerHandler('search_finish', [iterator]);
    });
    
    input.bind('keyup', function() {
        startSearch();
    });
    
    $selContainer.size() && (function() {
        
        var $selMain = $this.find('.b-client-list__selectors__main'),
            $selectors = $this.find('.b-client-list__selectors__ch'),
            selParams = $selContainer.get(0).onclick(),
            visible = [],
            selected = [];
        
        function updateSelected() {
            var allChecked = visible.length > 0,
                selected = [];
                
            for (var i = 0; i < visible.length; i++) {
                if ($selectors.eq(visible[i]).size() == 0) continue;
                
                if (!$selectors.eq(visible[i]).prop('checked')) {
                    allChecked = false;
                } else {
                    selected.push(visible[i]);
                }
            };
            $selMain.prop('checked', allChecked);
            notifySelectedChanged(selected);
        }        
        
        // FIXME
        function notifySelectedChanged(selected) {
            $(selParams.list)
                .data('Selectors.Selected', selected)
                .triggerHandler('selection_change', [selected]);
                // note: triggerHandler won't return a jQuery object!
        }

        $selMain.bind('click', function() {
            var state = !!this.checked;
            
            for (var i = 0; i < visible.length; i++) {
                ($selectors.eq(visible[i])).prop('checked', state);
            }
            
            notifySelectedChanged(state ? visible : []);
        });

        $selectors.bind('click', updateSelected);
        
        for (var i = 0; i < $selectors.size(); i++) {
            if ($selectors.eq(i).closest('tr').css('display') != 'none') {
                visible.push(i);
            }
            
            if ($selectors.eq(i).prop('checked')) {
                selected.push(i);
            }
        }

        $(selParams.list)
            .bind('search_start', function() {
                $selMain.prop('disabled', true);
            })
            .bind('search_finish', function (e, options) {
                $selMain.prop('disabled', false);
                visible = options.visible;
                updateSelected();
            });
            
        notifySelectedChanged(selected);
    })();
    
    function showParent (row) {
        for (var i=0; i < row.group.length; i++) {
            row.group[i].style.display = '';
        };
        for (var i=0; i < row.children.length; i++) {
            row.children[i].style.display = 'none';
        };
    }
    
    function hideRow (row) {
        var items = row.group.concat(row.children);
        for (var i=0; i < items.length; i++) {
            items[i].style.display = 'none';
        }
    }
    
    function startSearch () {
        var query = {
            text: input.val()
        };
        if (query.text == lastQuery.text) return;
        
        lastQuery = query;
        list.search(query);
    }

    function highlight (row, iterator) {
        var $parent = row.node,
            description = list.items[iterator.iteration].description.toLowerCase(),
            descriptionMatched = iterator.query.text != '' && description.indexOf(iterator.query.text) != -1;
            
        highlightRow(row.node, iterator);
        row.toggle[ !iterator.empty && !iterator.matchedParent ? 'addClass' : 'removeClass' ]('hlted');
        row.description[descriptionMatched ? 'addClass' : 'removeClass']('hlted');
    }
    
    function highlightRow (row, iterator) {
        var originalValues = listTable.getOriginalValues(hltBlocks, row, iterator.iteration);
            
        listTable.getHltBlocks(hltBlocks, row, iterator.iteration).each(function(index) {
            var html = originalValues[index].replace(iterator.regexp, "<span class=\"hlted\">$1</span>");
            if (this.innerHTML != html) this.innerHTML = html;
        });
    }
};
})(jQuery, window.Lego);
