include('../../js/jq/direct/utils.js');

(function($, Lego) {
    Lego.block['b-comment-form-template'] = function(params) {
        var $this = $(this),
            groupTitles = params.groupTitles || [],
            beforeText = params.beforeText || '',
            afterText = params.afterText || '',
            $groupsContainer = $this.find('.b-comment-form-template__groups'),
            $groups = $groupsContainer.find('.b-comment-form-template__group'),
            $items = $groupsContainer.find('.b-comment-form-template__list__item'),
            $textarea = $this.find('.b-comment-form-template__textarea'),
            $acceptTypeSelect = $this.find('.b-comment-form-template__accept-type'),
            replaceAcceptTypeGroup,
            groups = [];
        init();

        /**
         * Инициализирует форму
         */
        function init() {
            $groups.each(function(i, element) {
                groups.push(parseGroup(element));
            });
            replaceAcceptTypeGroup = parseGroup($('.b-comment-form-template__accept-type-group'));
            update();
            $(document).bind('b-comment-form-template_open', updateHeight);
            $acceptTypeSelect.change(updateTextCurrentAcceptType);
            updateTextCurrentAcceptType();
        }

        /**
         * Подстраивает высоту формы под высоту содержимого textarea
         */
        function updateHeight() {
            var fix = document.compatMode == 'BackCompat' ? 0 : -4; // do we have to compensate for paddings and border?
		    if ($groupsContainer[0].offsetHeight) $textarea[0].style.height = ($groupsContainer[0].offsetHeight - 18 - 10 + fix) + 'px';
        }

        /**
         * Добавляет к шаблонам из groups чекбоксы и обработчик их клика
         */
        function update() {
            $.each(groups, function(i, group) {
                for (var j=0, k = group.templates.length; j < k; j++) {
				    createInput(group.templates[j]).bind('click', onInputClicked)
			    };
            })
        }

        /**
         * Получает строку комментария на основе группы шаблонов
         * @param {Array} groups группы шаблонов
         * @param {Array} groupTitles заголовки групп шаблонов
         * @returns {string}
         */
        function renderGroups(groups, groupTitles) {
            var texts = [], resultText = '';

            groupTitles || (groupTitles = []);

            $.each(groups, function(i, group) {
                texts[i] = [];
                $.each(group.templates, function(j, template) {
                    // рисуем шаблон если чекбокса нет или он выбран
                    if (!template.input || template.input.prop('checked')) {
                        texts[i].push(template.texts.join('\n'));
                    }
                })
            })

            $.each(texts, function(i, text) {
                if (text.length) {
                    if (groupTitles[i]) { resultText += groupTitles[i] + '\n'; }
                }
                if (text.length > 1) {
                    for (var j = 0, k = texts[i].length; j < k; j++) {
						text[j] = (j + 1) + '. ' + text[j];
					};
                }

                resultText += text.join('\n\n')+'\n\n';

            });

            return resultText;
        }

        /**
         * Обработчик клика на чекбокс шаблона
         */
        function onInputClicked() {
            // при кликах на чекбоксы независимо от текущего значения в $acceptTypeSelect
            // рисуем шаблоны из groups
            updateText({
                groups: groups,
                groupTitles: groupTitles,
                beforeText: beforeText,
                afterText: afterText
            });
        }

        /**
         * Устанавливает значение комментария на основе текущего выбранного Способа принятия
         */
        function updateTextCurrentAcceptType() {
            // рисуем содержимое textarea в зависимости от выбранного значения в $acceptTypeSelect
            $acceptTypeSelect.val() == 'replace' ?
                updateText({
                    groups: [replaceAcceptTypeGroup]
                }) :
                updateText({
                    groups: groups,
                    groupTitles: groupTitles,
                    beforeText: beforeText,
                    afterText: afterText
                });
        }

        /**
         * Обновляет текст в поле с комментарием
         * @param {String} params.beforeText текст до текста из шаблонов
         * @param {String} params.afterText текст после текста из шаблонов
         * @param {Array} params.groups группы шаблонов
         * @param {Array} params.groupTitles заголовки групп шаблонов
         */
        function updateText(params) {
            var before = params.beforeText || '',
                after = params.afterText || '';

            $textarea.val(before + renderGroups(params.groups, params.groupTitles) + after);
        }

        /**
         * Парсит группу шаблонов заданную на DOM ноде
         * @param {HTMLElement} element нода группы шаблонов
         * @returns {Object} группа шаблонов
         */
        function parseGroup(element) {
            var $group = $(element),
                group = { templates: [] },
                name = $group.data('name');

            $group.find('dl').each(function(j, template) {
                group.templates.push(parseTemplate(template, name, j));
            });
            group.name = $group.find('h3').text();
            group.element = $group;

            return group;
        }

        /**
         * Парсит шаблон заданный на DOM ноде
         * @param {HTMLElement} element нода шаблона группы
         * @param name название чекбокса
         * @param counter порядковый номер шаблона
         * @returns {Object} шаблон
         */
        function parseTemplate(element, name, counter) {
            var template = {}, $template = $(element);
            template.checkboxName = name;
            template.counter = counter;
            template.nameElement = $template.find('dt');
            template.textElements = $template.find('dd');
            template.name = template.nameElement.text();
            template.texts = $.makeArray(template.textElements.map(function() {
                return $(this).html();
            }));
            template.element = $template;
            return template;
        }

        /**
         * Создает чекбокс для шаблона
         * @param template шаблон
         * @returns {HTMLElement} чеббокс шаблона
         */
        function createInput(template) {
            var id = direct.utils.generateId(),
                input = $("<input name='" + template.checkboxName + '-' + template.counter + "' type='checkbox' class='checkbox-old' id='" + id + "'></input>"),
                label = $("<label for='" + id + "'>" + template.name + "</label>");

            template.nameElement.empty().append(input).append(label);
            template.input = input;
            return input;
        }

        $items.each(function() {
            var $switcher = $(this).find('.b-comment-form-template__switcher'),
                $content = $(this).find('.b-comment-form-template__group__i');
            $switcher.click(function() {
                $content.toggleClass('g-hidden');
                updateHeight();
            });
        });

        
    }
})(jQuery, window.Lego);

