BEM.DOM.decl('b-condition-goal-time', {
    onSetMod: {
        js: function() {
            this.popup = this.findBlockInside('b-popupa');

            this.input = this.findBlockInside('b-form-input');
            this.ok = this.findBlockOn(this.elem('ok'), 'b-form-button');
            this.cancel = this.findBlockOn(this.elem('cancel'), 'b-form-button');

            //кэшируем элемент заранее
            this.elem('errors');

            this.input.on('change', function() {
                this.afterCurrentEvent(function() {
                    this.delMod(this.elem('content'), 'errors');
                })
            }, this);

            this.ok.on('click', function() {
                var value = this.input.val();

                if (!BEM.blocks['i-formater'].isInteger(value) || value < 1 || value > 30) {
                    this.elem('errors').text(iget('Количество дней должно быть числом от 1 до 30'));
                    this.setMod(this.elem('content'), 'errors', 'yes');

                } else {
                    this.popup.hide();
                    this.parent.trigger('change-time', +value);
                }
            }, this);

            this.cancel.on('click', function() {
                this.hide();
            }, this);

        }
    },

    show: function(owner) {
        this.popup.show(owner);
    },

    hide: function() {
        this.popup.hide();
    },

    setParent: function(parent) {
        this.parent = parent;
        this.delMod(this.elem('content'), 'errors');
        this.input.val(this.parent.elem('time-hidden').val());

        return this;
    }
}, {

});


BEM.HTML.decl('b-condition-goal-time', {
    onBlock: function(ctx) {
        ctx
            .js(true)
            .tag('span')
            .content({
                block: 'b-popupa',
                content: [
                    { elem: 'tail' },
                    {
                        elem: 'content',
                        mix: [{ block: 'b-condition-goal-time', elem: 'content' }],
                        content: [
                            {
                                block: 'b-condition-goal-time',
                                elem: 'errors'
                            },
                            {
                                block: 'b-form-input',
                                mix: [{ block: 'b-condition-goal-time', elem: 'input' }]

                            },
                            {
                                tag: 'span',
                                content: iget('дней')
                            },
                            {
                                block: 'b-condition-goal-time',
                                elem: 'controls',
                                content: [{
                                    block: 'b-form-button',
                                    mix: [{ block: 'b-condition-goal-time', elem: 'ok' }],
                                    mods: { type: 'button' },
                                    content: iget('OK')
                                },
                                {
                                    block: 'b-form-button',
                                    mix: [{ block: 'b-condition-goal-time', elem: 'cancel' }],
                                    mods: { type: 'button' },
                                    content: iget('Отмена')
                                }]
                            }
                        ]
                    }
                ]})
    }
});
