(function($){
    BEM.DOM.decl('b-condition-goal', {
        onSetMod: {
            'js': function(){
                var _this = this;
                this.parent = this.findBlockOutside('b-condition-group');
                this.bindTo('add', 'click', this.onAdd)
                    .bindTo('remove', 'click', this.onRemove)
                    .bindTo('goals', 'change', this.onChange);

                this.timeLink = this.findBlockOn(this.elem('time-text'), 'b-pseudo-link')
                    .on('click', this.onTimeClick, this);

                this.on('change-time', function(e, value) {
                    this.elem('time-hidden').val(value);
                    this.elem('time-text').html(value + ' ' + common.inflector.pluralizeWord([iget('день'), iget('дня'), iget('дней')], value));
                    this.parent.trigger('change');
                }, this)

            }
        },

        onChange: function() {
            this.parent.trigger('change');
            this.setMod('allow',
                BEM.blocks['i-get-goals-ajax'].getGoalById(this.elem('goals').val()).allow_to_use ? 'yes' : 'no');
        },

        setDisabled: function(disabled) {
            this.setMod('disabled', disabled ? 'yes' : 'no');

            this.timeLink.setMod('disabled', disabled ? 'yes' : 'no');
            this.elem('goals').prop('disabled', disabled);

        },

        getData: function() {
            return {
                goal_id: this.elem('goals').val(),
                time: this.elem('time-hidden').val()
            }
        },

        onTimeClick: function() {
            this.getTimePopup().setParent(this).show(this.elem('time-text'));
        },

        getTimePopup: function() {
            if (this.__self.timePopup)  return this.__self.timePopup;

            this.__self.timePopup = $(BEM.HTML.build({
                block: 'b-condition-goal-time',
                js: true
            })).bem('b-condition-goal-time');

            return this.__self.timePopup;
        },

        onAdd: function() {
            this.parent
                .trigger('change')
                .trigger('add-goal');
        },

        onRemove: function() {
            this.domElem.remove();
            this.parent
                .trigger('change')
                .trigger('remove-goal');
        },

        setNum: function(num) {
            this.elem('num').text(num + '.')
        }

    }, {

    });

    BEM.HTML.decl('b-condition-goal', {
        onBlock: function(ctx){

            var currGoal = ctx.param('goal_id') ? BEM.blocks['i-get-goals-ajax'].getGoalById(ctx.param('goal_id')) : 0,
                goals = BEM.blocks['i-get-goals-ajax'].getGoals(),
                allow = currGoal ?
                        currGoal.allow_to_use ? 'yes' : 'no' :
                        goals[0].allow_to_use ? 'yes' : 'no';
            ctx
                .js(true)
                .mods({ allow: allow })
                .content([
                    { elem: 'num', content: ctx.param('num') + '.', tag: 'span'},
                    {
                        elem: 'goals',
                        goal_id: ctx.param('goal_id')
                    },
                    { tag: 'span', content: '&nbsp;' + iget('за') + '&nbsp;'},
                    { elem: 'time', time: ctx.param('time')},
                    { elem: 'remove'},
                    { elem: 'add'}
                ]);
        },

        onElem: {
            'goals': function(ctx) {
                var goalId = ctx.param('goal_id'),
                    goals = BEM.blocks['i-get-goals-ajax'].getGoals(),
                    content = [], attrs;

                for (var i = 0; i < goals.length; i++) {
                    attrs = {value: goals[i].goal_id};
                    if (goals[i].goal_id == ctx.param('goal_id')) {
                        attrs['selected'] = 'selected';
                    }
                    if (goals[i].allow_to_use || goals[i].goal_id == goalId) {
                        content.push({
                            tag: 'option',
                            elem: 'goal',
                            mods: { 'allow': goals[i].allow_to_use ? 'yes' : 'no' },
                            attrs: attrs,
                            content: goals[i].goal_domain + ' :: ' + goals[i].goal_name
                        });
                    }
                }
                ctx
                    .tag('select')
                    .content(content)
            },
            'time': function(ctx) {
                   var time = ctx.param('time') || 30,
                       timeText = time + '&nbsp;' + common.inflector.pluralizeWord([iget('день'), iget('дня'), iget('дней')], time);

                   ctx
                       .tag('span')
                       .content([
                           {
                               tag: 'span',
                               block: 'b-pseudo-link',
                               mods: { 'is-bem': 'yes' },
                               mix: [{ elem: 'time-text', block: 'b-condition-goal' }],
                               content: timeText
                           },
                           {
                               tag: 'input',
                               attrs: { type: 'hidden', value: time },
                               elem: 'time-hidden'
                           }
                       ]);
            }
        }
    });
})(jQuery);

