
(function($){

    BEM.DOM.decl('b-condition-group', {
        onSetMod: {
            'js': function(){
                this.goals = this.findBlocksInside('b-condition-goal');
                this.goalNum = this.goals.length;
                this
                    .on('add-goal', this.onAddGoal, this)
                    .on('remove-goal', this.onRemoveGoal, this );


                this
                    .bindTo('delete', 'click', this.deleteGroup)
                    .bindTo('select', 'change', function() {
                        this.trigger('change');
                    })
            }
        },

        setDisabled: function(disabled) {
            this.elem('select').prop('disabled', disabled);
            $.each(this.goals, function(i, goal) {
                goal.setDisabled(disabled);
            })
        },

        getData: function() {
            return {
                type: this.elem('select').val(),
                goals: this.getGoals()
            }
        },

        getGoals: function() {
            return $.map(this.goals, function(el){ return el.getData() });
        },

        setOne: function(isOne) {
            this.elem('delete').toggleClass('g-hidden', isOne)
        },

        setLast: function(isLast) {
            this.elem('and').toggleClass('g-hidden', isLast)
        },

        setNum: function(num) {
            this.elem('group-num').text(iget('Группа') + ' ' + num);
        },

        deleteGroup: function() {
            this.domElem.remove();
            BEM.blocks['b-condition-group'].trigger('delete-group');
        },

        refreshGoalsList: function(goals) {
            var self = this;
            $.each(goals, function(i, goal) {
                goal.setNum(i + 1);
                if (self.goalNum == 1) {
                    goal.setMod('remove', 'no').setMod('add', 'yes');
                } else if (i == self.goalNum - 1) {
                    goal.setMod('remove', 'yes').setMod('add', i == MAX_RETARGETING_GOALS_IN_GROUP - 1 ? 'no' : 'yes');
                } else {
                    goal.setMod('remove', 'yes').setMod('add', 'no');
                }
            })
        },


        onAddGoal: function() {
            this.elem('goals').append(
                 BEM.HTML.build({
                     block: 'b-condition-goal',
                     num: this.goalNum + 1
                 }));

            this.onRemoveGoal();
        },

        onRemoveGoal: function() {
            this.goals = this.findBlocksInside('b-condition-goal');
            this.goalNum = this.goals.length;
            this.refreshGoalsList(this.goals);
        }

    }, {

    });

    BEM.HTML.decl('b-condition-group', {

        onBlock: function(ctx){
                ctx
                    .js(true)
                    .content([
                        {elem: 'label', id: ctx.param('id')},
                        {elem: 'select', type: ctx.param('type')},
                        {
                            elem: 'goals',
                            goals: ctx.param('goals')
                        },
                        {elem: 'and', content: iget('и')}
                    ]);
            },

        onElem: {
            'label': function(ctx){
                ctx
                    .content([
                        {
                            elem: 'group-num',
                            tag: 'span',
                            content: iget('Группа') + ' ' + ctx.param('id')
                        },
                        {
                            elem: 'delete'
                        }
                    ])
            },

            'select': function(ctx) {
                var type = ctx.param('type') || 'or',
                    attrs = {
                    'not': {value: 'not'},
                    'all': {value: 'all'},
                    'or': {value: 'or'}
                };
                attrs[type].selected = 'selected';
                ctx
                    .tag('select')
                    .content([
                        {tag: 'option', attrs: attrs.not, content: iget('Не достигнута ни одна из целей')},
                        {tag: 'option', attrs: attrs.all, content: iget('Достигнуты все цели')},
                        {tag: 'option', attrs: attrs.or, content: iget('Достигнута хотя бы одна из целей')}
                    ])
            },

            'goals': function(ctx) {
                var goals = ctx.param('goals'),
                    goalsData = [];
                if (!goals) {
                    goalsData.push({
                        block: 'b-condition-goal',
                        num: 1,
                        mods: {add: 'yes', remove: 'no'}
                    });
                } else {
                    $.each(goals, function(i, goal) {
                        goalsData.push({
                            block: 'b-condition-goal',
                            mods: {add: goals.length == i + 1 ? 'yes' : 'no', remove: goals.length > 1 ? 'yes' : 'no'} ,
                            num: i + 1,
                            goal_id: goals[i].goal_id,
                            time: goals[i].time
                        })
                    });
                }

                ctx
                    .content(goalsData);
            }
        }


    });
})(jQuery);
