(function($) {
    BEM.DOM.decl({name:'b-conditions-saved'}, {
        onSetMod : {
            js: function() {
                this.cancel = this.findBlockOn('cancel', 'b-form-button').on('click', this.cancel, this);
                this.save = this.findBlockOn('save', 'b-form-button').on('click', this.save, this) ;
                BEM.channel('i-retargeting-conditions').on('change', this.buildConditions, this);
                this.buildConditions({ isInit: true });
                this.updateSaveBtn();
            }
        },



        buildConditions: function(data) {
            var isInit = data && data.isInit,
                conditions =  BEM.blocks['i-retargeting-conditions'].getAll(),
                checked = !isInit ? this.getModel().get('retargeting_conditions_id').split(',') :  false;


            this.afterCurrentEvent(function() {
                this.dropElemCache('edit condition');
                BEM.DOM.update(this.elem('conditions'), BEM.HTML.build({
                    block:'b-retargeting-conditions-list',
                    conditions: conditions,
                    mode:'popup',
                    mods:{'mode':'popup'},
                    // DIRECT-23253: Медиапланеру доступна кнопка редактирования условий ретаргетинга в медиаплане и ПП
                    readOnly: this.params.readOnly
                }));

                this.findBlocksInside(this.popupaElem, 'b-retargeting-conditions-tr');
                BEM.blocks['b-retargeting-conditions-tr']
                    .on('edit-click', this.editCondition, this)
                    .on('change', this.updateSaveBtn, this);

                this.cbxList = this.findBlockInside('b-checkboxes-group');
                // DIRECT-23230 Сбрасываются выбранные условия ретаргетинга при редактировании ранее сохраненного
                checked && this.cbxList.setChecked(checked);
            });


        },



        updateSaveBtn: function() {
            this.save.setMod('disabled', !this.cbxList || this.cbxList.getChecked().length == 0 ? 'yes' : 'no')
        },

        editCondition: function(e, data) {
            var id = data.id,
                retWindow = BEM.blocks['b-retargeting-window'].getInstance(),
                checked = this.cbxList.getChecked();

            // DIRECT-23230 Сбрасываются выбранные условия ретаргетинга при редактировании ранее сохраненного
            this.cbxList && this.afterCurrentEvent(function() {
                this.cbxList.setAllState(false);
                this.cbxList.setChecked(checked);
            }, this);

            retWindow.initConditionById(id);
            retWindow.switchAction('edit');
        },


        cancel: function() {
            BEM.blocks['b-retargeting-window'].getInstance().hide();
            this.cbxList.setAllState('no');
        },

        getModel: function() {
            return BEM.blocks['i-models-manager'].get('campaign&banner:' + BEM.blocks['b-retargeting-window'].getInstance().getParam('bid'), this.params.modelName);
        },

        save: function() {
            var model = this.getModel(),
                ids =  this.cbxList.getChecked();

            model.update({
                'retargeting_conditions_id': ids.join(',')
            }, this);


            BEM.blocks['b-retargeting-window'].getInstance().hide();
            this.cbxList && this.cbxList.setAllState('no');
        }
    }, {
        live: true
    })

})(jQuery);

