(function($){
    BEM.DOM.decl('b-confirm', {
        onSetMod: {
            'js': function() {
                var self = this;
                self.bindTo('ok', 'click', function() {
                    self.hide();
                    self.trigger('ok');
                });
                self.bindTo('cancel', 'click', function() {
                    self.hide();
                    self.trigger('cancel')
                })
             }
        },

        show: function() {
            this.getPopup().show();
        },

        hide: function() {
            this.getPopup().hide();
        },

        getPopup: function() {
            return this._popup || (this._popup = this.findBlockInside('b-popupa'));
        }

    });

    BEM.HTML.decl('b-confirm', {
        onBlock : function(ctx) {
            ctx
                .js(true)
                .content({
                    block: 'b-popupa',
                    mods: {
                        direction: 'fixed'
                    },
                    js: {
                        underMods: {
                            type: 'paranja'
                        }
                    },
                    content: [
                        { elem: 'close', tag: 'i' },
                        {
                            elem: 'content',
                            content : [
                                {
                                    elem: 'message',
                                    content: ctx.param('message')
                                },
                                {

                                    elem: 'controls',
                                    content: [
                                        {
                                            mix: [{elem: 'ok', block: 'b-confirm'}],
                                            content: iget('OK'),
                                            block: 'b-form-button',
                                            mods: { valign: 'middle' },
                                            type: 'submit'

                                        },
                                        {
                                            mix: [{elem: 'cancel', block: 'b-confirm'}],
                                            content: iget('Отмена'),
                                            block: 'b-form-button',
                                            mods: { valign: 'middle' },
                                            type: 'submit'
                                        }

                                    ]


                                }
                            ]
                        }
                    ]
                })

        }


    });


})(jQuery);
