(function($) {

    BEM.DOM.decl({name:'b-context-limit-view'}, {
        onSetMod : {
            js: function() {
                this.model = BEM.blocks['i-models-manager'].get('campaign', 'b-context-limit');
                this.model.onField('ContextLimit', 'change', this.onContextLimitChange, this);
                this.model.on('rollback', this.onContextLimitChange, this);
                this.setAutoBtn = this.findBlockInside('set-auto-block', 'b-form-button');
                this.setAutoBtn.on('click', $.proxy(this.setAuto, this));
            }

        },

        setAuto: function() {
            this.model.update({
                ContextLimit: 100,
                ContextPriceCoef: 100,
                disableBehavior: '',
                statusContextStop: ''
            }, this);
            this.model.fixData();
            this.elem('content').text(iget('Стандартные'))
        },

        onContextLimitChange: function() {
            this.elem('set-auto-block').toggleClass('g-hidden', this.model.get('ContextLimit') != 254);
            this.elem('main-block').toggleClass('g-hidden', this.model.get('ContextLimit') == 254);
        }
    });




})(jQuery);

