(function($) {
    //utility - вспомогательное поле
    //server - отправляется на сервер
    //serverName - имя для хранения на сервере
    //input - напрямую вводится пользователем

    BEM.blocks['b-model'].register('b-context-limit', {
        fields: {
            'ContextLimit': {type: 'number', fromServer: 1, toServer: 1, input: 1, 'default': 100, precision: 0},
            'ContextPriceCoef': {type: 'number', fromServer: 1, toServer: 1, input: 1, 'default': 100, precision: 0},
            'disableBehavior': {type: 'flag', fromServer: 1, toServer: 1, input: 1}
        }
    });

    BEM.DOM.decl({name:'b-context-limit', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                this.strategyModel = BEM.blocks['i-models-manager'].get('campaign', 'campaign-strategy');
                this.savedState = {};
                this.initConsts();
                this.initModel();
                this.bindEvents();
                this.contextLimitPrev = this.model.get('ContextLimit');
                this.adjustDisabled();
            }

        },

        initConsts: function() {
            this._modelPath = 'campaign';
            this._modelName = 'b-context-limit';
        },



        onElemSetMod: {
            'ContextLimit-row': {
                'disabled': function(el, modName, modVal) {
                    this.elem('ContextLimit').prop('disabled', modVal == 'yes');
                    el.toggleClass('g-common__gray', modVal == 'yes');
                }
            },
            'ContextPriceCoef-row': {
                'disabled': function(el, modName, modVal) {
                    this.elem('ContextPriceCoef').prop('disabled', modVal == 'yes');
                    el.toggleClass('g-common__gray', modVal == 'yes');
                }
            },
            'statusContextStop-row': {
                'disabled': function(el, modName, modVal) {
                    this.elem('statusContextStop').prop('disabled', modVal == 'yes');
                    el.toggleClass('g-common__gray', modVal == 'yes');

                }
            },
            'disableBehavior-row': {
                'disabled': function(el, modName, modVal) {
                    this.elem('disableBehavior').prop('disabled', modVal == 'yes');
                    el.toggleClass('g-common__gray', modVal == 'yes');
                }
            }
        },

        bindEvents: function() {
            this.__base();
            this.strategyModel
                .onField('name', 'change', this.onStrategyChange, this)
                .onField('search_srategy', 'change', this.onStrategyChange, this);

            this.bindTo('ContextLimit', 'change', this.onLimitChange);
            this.model.onField('ContextLimit', 'change', this.onLimitChanged, this);
            this.model.on('rollback', function() {
                this.contextLimitPrev = undefined;
            }, this);
        },

        onStrategyChange: function(e) {
            this.__self.onStrategyChange(this, e);
            this.adjustDisabled();

            this.trigger('change')
        },

        onLimitChange: function() {
            var _this = this;
            setTimeout(function() {  //DIRECT-29544 - не закрывается окно об отключении тематических площадок на айпаде
                var limit = _this.model.get('ContextLimit');
                if (limit == 254) {
                    if ((_this.contextLimitPrev != 254) && !confirm(
                        iget('Расход в пределах "0%" означает, что вы ПОЛНОСТЬЮ отключаете показы на тематических площадках.') + '\n\n' +
                            iget('Обратите внимание: отключая показы на тематических площадках, вы можете лишиться целевых посетителей. Если показы не отключены, в разделе статистики будут предоставлены данные по каждой площадке и возможность отключения показов на каждой площадке выборочно.') + "\n\n" +
                            iget('Отключить показы объявлений на тематических площадках Рекламной сети Яндекса?')
                    )) {
                        _this.model.set('ContextLimit', _this.contextLimitPrev);
                        return false;
                    } else {
                        _this.contextLimitPrev  = limit;
                    }
                } else {
                    _this.contextLimitPrev  = limit;
                }
            }, 0)
        },

        onLimitChanged: function() {
            this.adjustDisabled();
        },

        finish: function() {},


        onExternalChange: function(e) {
            this.__self.onExternalChange(this, e);
            return this;
        },


        adjustDisabled: function() {
            var isDiffPlaces = this.strategyModel.get('name') == 'different_places',
                netStrategy = this.strategyModel.get('net_strategy'),
                limit = this.model.get('ContextLimit');

            // Если выбраны автобюджетные стратегии по Средней цене или Недельный пакет кликов по средней цене
            // для тематических площадок – нужно дизейблить в Настройках на тематических площадках
            // ограничение на макс цену за клик в состоянии 100%
            isDiffPlaces &&
                (netStrategy == 'autobudget_avg_click' || netStrategy == 'autobudget_week_bundle') &&
            this.elem('ContextLimit').val(100);
            this.toggleMod(this.elem('ContextLimit-row'), 'disabled', 'yes' , 'no', isDiffPlaces);
            this.toggleMod(this.elem('ContextPriceCoef-row'), 'disabled', 'yes' , 'no', isDiffPlaces || limit == 254);
            this.toggleMod(this.elem('disableBehavior-row'), 'disabled', 'yes' , 'no', limit == 254);
        }

    }, {
        getButtonText: function() {
            return iget('изменить')
        },

        onStrategyChange: function(ctx, e) {
            var model = ctx.model,
                strategyModel = ctx.strategyModel || BEM.blocks['i-models-manager'].get('campaign', 'campaign-strategy');
            var strategy = strategyModel.get('name'),
                defaults = model.getModelStartValue();
            if (strategy == 'different_places') {
                var data = {
                    ContextLimit: 100,
                    ContextPriceCoef: 100
                };
                this.savedState = this.savedState || {};
                if ( !e.changes || e.changes.strategy) {
                    this.savedState.ContextLimit = model.get('ContextLimit');
                    this.savedState.ContextPriceCoef = model.get('ContextPriceCoef') || defaults.ContextPriceCoef; // "или" добавлено для DIRECT-14489
                }

                model.update(data);
            } else if (!$.isEmptyObject(this.savedState)) {
                model.update(this.savedState)
            }
            model.fixData();
        },

        onExternalChange: function(ctx, e) {
            this.onStrategyChange(ctx, e);
        },

        getText: function(ctx) {
            var limit = ctx.model.get('ContextLimit'),
                price = ctx.model.get('ContextPriceCoef'),
                disableBeh = ctx.model.get('disableBehavior'),
                stop = ctx.model.get('statusContextStop'),
                text = [];

            //сделал логику как в tt2 шаблоне #DIRECT-18641
            if (limit == 100 && price == 100 && !disableBeh && !stop)
                return iget('Стандартные');
            else if (limit != 254) {
                if (limit == 0)
                    text.push(iget("Ограничение расхода на&nbsp;тематических площадках не&nbsp;задано."));
                else if (limit == 255)
                    text.push(iget("Расход на&nbsp;тематических площадках не&nbsp;ограничен."));
                else
                    text.push(iget("Расход на тематических площадках удерживать в&nbsp;пределах %s% от общего расхода кампании.").replace(/%s/, limit));

                price &&
                text.push(iget("Максимальная цена за&nbsp;клик&nbsp;&mdash; %s% от максимальной цены на поиске.").replace(/%s/, price));

                text.push(disableBeh == 1 ?
                    iget("Предпочтения пользователей не&nbsp;учитываются.") :
                    iget("Предпочтения пользователей учитываются."));

                if (stop == 1)
                    text.push(iget("Показы останавливаются при отключении фраз на поиске."));
            }

            return text.join("<br>");
        },
        live: true
    });




})(jQuery);
