(function($){

BEM.DOM.decl('b-convert-page', {
    onSetMod: {
        'js': function(){
            this.emailInput = this.findBlockInside('email-input', 'b-form-input');

            this.dateInput = this.findBlockInside('date-input', 'b-date-input');

            if (this.dateInput) {
                var dI = this.dateInput,
                    dIValue = dI.value(),
                    date = Date.fromString(dIValue);

                dI.updateExternal(dIValue);
                dI.createDatePicker({start: date, end: new Date(date).addDays(16)});
            }

            this.submitButton = this.findBlockInside('submit', 'b-form-button');

            this.agree = this.findBlockInside('agree', 'b-form-checkbox');

            if (this.agree) {
                this.agree.on('change', function() {
                    this.submitButton.setMod('disabled', this.agree.isChecked() ? '' : 'yes');
                }, this);
            }
        }
    }

}, {});

})(jQuery);

(function($){

BEM.DOM.decl('b-convert-page-time-chooser', {
    onSetMod: {
        'js': function(){
            this.dateInput = this.findBlockInside('date-input', 'b-date-input');

            this
                .bindTo('now in-time', 'change', function(){
                    this.setMod('value',  this.getMod('value') == 'now' ? 'in-time' : 'now');
                })
                .elem(this.params.initValue.replace('_', '-')).prop('checked', true).trigger('change');
        },

        'value': function(){
            var state = arguments[1] == 'in-time';

            this.elem(arguments[1]).prop('checked', true);
            this.setMod(this.elem('time-choose-label'), 'disabled', state ? 'no' : 'yes');
            this.elem('hour-select').add(this.elem('minute-select')).prop('disabled', !state);
            this.setMod(this.elem('in-time-block'), 'disabled', state ? '' : 'yes');
            this.dateInput.setDisabled(!state);
        }
    }
}, {});

})(jQuery);
