(function($) {
    //формат даты в модели
    var modelDateFormat = 'yyyy-mm-dd',
    //формат даты, который отображается в текстовом инпуте
        viewDateFormat = 'dd mmm yyyy';

    var CURRENT_DATE = (new Date()).zeroTime();

    BEM.DOM.decl('b-date-input', {
        onSetMod : {
            js: function() {
                var self = this;
                this.input = this.findBlockOn('input-wrapper', 'b-form-input');
                this.btn = this.findBlockOn('btn', 'b-form-button');
                this.init();
                BEM.DOM.blocks['b-campaign-edit-block'].on('open',function(e, elem) {
                   if (elem != self) {
                       self.close();
                   }
                });
            }
        },

        setDisabled: function(disabled) {
            this.input.setMod('disabled' , disabled ? 'yes' : 'no') ;
            this.btn.setMod('disabled' , disabled ? 'yes' : 'no');
            this.elem('hidden').prop('disabled', !!disabled)
        },


        openCalendar: function(datestr) {
            BEM.DOM.blocks['b-campaign-edit-block'].trigger('open', this);
            //если не выбрана дата - показываем на календаре текущую
            if (datestr) { this.elem('btn').dpSetSelected(new Date().asString(), true, true, false); }
            this.elem('btn').dpDisplay();
        },

        updateFromCalendar: function(date) {
            this.setHidden(date.asString(modelDateFormat));
            this.input.val(date.asString(viewDateFormat));
            this.trigger('change');
        },

        value: function() {
            return this.elem('hidden').val();
        },

        clearDate: function() {
            this.setHidden('');
            this.elem('input').val('');
            this.elem('btn').dpClearSelected();
        },

        updateExternal: function(datestr) {
            //DIRECT-15482
            if (datestr == '--') { datestr = ''; }
            this.setHidden(datestr);
            this.input.val(datestr ? Date.fromString(datestr, modelDateFormat).asString(viewDateFormat) : '');
            this.elem('btn').dpClose().dpSetSelected(datestr);
        },

        setHidden: function(value) {
            this.elem('hidden').val(value).change();
        },

        setFinishBounds: function(datestr) {
            var d = Date.fromString(datestr, modelDateFormat);

            this.elem('btn').dpSetStartDate(
                (d && d.getTime() >= CURRENT_DATE.getTime() ? d : CURRENT_DATE).asString());
        },



        bindEvents: function() {
            var self = this;

            this.input.on('click focus', function() {
                self.openCalendar();
                self.elem('input').blur();
                return false;
            });

            this.btn.on('click', function() {
                self.openCalendar();
                self.elem('input').blur();
                return false;
            });

            this.elem('btn')
                .bind('dateSelected', function(e, selectedDate) {
                    self.updateFromCalendar(selectedDate);
                })
                .bind('clearSelected', function(e) {
                     self.clearDate()
                });
        },

        close: function() {
            this.elem('btn').dpClose();
        },

        init: function() {
            this.setLocalization();
        },

        setLocalization: function() {
            $.dpText = {
                TEXT_PREV_YEAR     : iget('Предыдущий год'),
                TEXT_PREV_MONTH    : iget('Предыдущий месяц'),
                TEXT_NEXT_YEAR     : iget('Следующий год'),
                TEXT_NEXT_MONTH    : iget('Следующий месяц'),
                TEXT_CLOSE         : iget('Закрыть'),
                TEXT_CHOOSE_DATE   : iget('Выбрать дату'),
                TEXT_CLEAR         : iget('Очистить'),
                TEXT_TODAY         : iget('Сегодня'),
                HEADER_FORMAT_YEAR : 'yyyy',
                HEADER_FORMAT_MONTH: 'mmmm'
            }
        },

        createDatePicker: function(date) {
            var pickerData = { createButton: false, startDate: date.start };

            if (date.end) pickerData.endDate = date.end;

            this.elem('btn').datePicker(pickerData).dpSetOffset(25, 0);
            this.bindEvents();
        }
    });



})(jQuery);


