(function($){
    BEM.blocks['b-model'].register('b-day-budget', {

        fields: {
            'daily_change_count' : {type: 'number'},
            'show_mode': {type: 'string', 'default': 'default'},
            'sum': {type: 'number', precision: 2, 'default': '', defaultView: ''},
            'set': {type: 'flag', 'default': false},

            'currency': {type: 'const', 'default': 'YND_FIXED'}
        },

        validateRules: function(){
            var curr = get_currency(this.get('currency'));
            return {
                'sum': {

                    'list': [
                        { id: 'required', name: 'required', text: iget('Не указана сумма дневного бюджета.')},
                        { id: 'format', name: 'format', text: iget("Неверно указана сумма дневного бюджета.")},
                        {
                            id: 'min', name: 'min', value: curr.MIN_DAY_BUDGET,
                            text: iget('Сумма дневного бюджета не может быть меньше %s', format_const(this.get('currency'), 'MIN_DAY_BUDGET'))
                        }
                    ],
                    'condition': function() { return this.get('set') }
                }
            }
        }
    });

    BEM.DOM.decl({name: 'b-day-budget', baseBlock: 'b-model-block'}, {
        onSetMod: {
            'js': function(){
                var popupa = this.findBlockOutside('b-popupa'),
                    _this = this;

                this.initConsts();
                this.initModel();
                this.bindErrorEvents();


                this.setCheckbox =
                    this.findBlockOn('set', 'b-form-checkbox').on('change', function(){ this.model.set('set', this.setCheckbox.isChecked()) }, this);


                this.elem('set-label').click(function(){ _this.setCheckbox.toggle() });

                this.model
                    .on('reset', function(){ _this.updateDomByModel() })
                    .onField('set', 'change', function(){ this.onSetChange() }, this)
                    .onField('sum', 'change', function(){ this.onSumChange() }, this)
                    .onField('show_mode', 'change', function(){ this.onShowModeChange() }, this);


                this.elem('sum').change(function(){
                    var model = _this.model,
                        max = _this.params.MAX_DAY_BUDGET_DAILY_CHANGE_COUNT;

                    if (model.stateData.daily_change_count < max) {
                        model.set('sum', this.value);
                    }
                    else {
                        var stateSum = model.stateData.sum > 0 ? model.stateData.sum : '';

                        this.value != stateSum && alert(iget('Дневной бюджет можно менять не более %s в день.',
                            max + ' ' + common.inflector.pluralizeWord([iget('раза'), iget('раз'), iget('раз')], max)));
                        this.value = stateSum;
                    }
                });

                this.elem('show-mode').change(function(){ _this.model.set('show_mode', this.value) });

                popupa.tabbedPane.on('currentStrat', function(e, currStrat){
                    // стучай стратегии different-places обрабатываем отдельно (внутри блока самой стратегии)
                    currStrat != 'different-places' &&
                        // если в названии выбранной стратегии есть слово autobudget -- дизаблим дневной бюджет
                        this.toggleMod('mod', 'disabled', currStrat.indexOf('autobudget') != -1);
                }, this);

                // init
                this.updateDomByModel();

            }
        },

        getDayBudgetData: function(){
            var model = this.model,
                dayBudget;

            model.stateData = model.memento();
            dayBudget = {
                set: !!model.stateData.set,
                sum: model.stateData.sum,
                show_mode: model.stateData.show_mode
            };

            return {
                dayBudget: dayBudget,
                text: dayBudget.set ?

                    '<div>' +
                        iget('Дневной бюджет %s', format_sum_of_money(model.get('currency'), dayBudget.sum)) +
                        ', ' + iget('%s режим показов', this.elem('show-mode').find('[value=' + dayBudget.show_mode + ']').text()) +
                    '</div>' :

                    ''
            }
        },

        updateDomByModel: function(){
            var model = this.model;

            model.stateData = model.memento();

            model.set('set', model.get('sum') > 0);

            this.onSumChange();
            this.onSetChange();
            this.onShowModeChange();
        },

        onSetChange: function () {
            var set = !!this.model.get('set');

            this.setCheckbox.toggleMod('checked', 'yes', set);
            this.elem('options').css('visibility', set ? 'visible' : 'hidden');
            this.toggleMod(this.elem('set-label'), 'mod', 'disabled', !set)
        },

        onSumChange: function () {
            this.elem('sum').val(this.model.get('sum') ? this.model.view('sum') : '');
        },

        onShowModeChange: function () {
            this.elem('show-mode').val(this.model.get('show_mode'));
        }


    }, {
        live: true
    });

})(jQuery);
