BEM.DOM.decl('b-device-targeting-item', {
    onSetMod: {
        'js': function () {
            var _this = this;

            this.checkbox = this.findBlockInside('b-form-checkbox');
            this.items = this.findBlocksInside('b-device-targeting-item').slice(1); //Удаляем текущий блок из списка

            this.onInternalChange();

            this.checkbox.on('change', this.onChange, this);
            $.map(this.items, function(item) {
                item.checkbox.on('change', _this.onInternalChange, _this);
            });
        }
    },

    /**
     * Меняет внутренние чекбоксы, в зависимости от значения главного.
     */
    onChange: function (){
        var checked = this.checkbox.getMod('checked') == 'yes';

        $.map(this.items, function(item) {
            item.checkbox.setMod('checked', checked ? 'yes' : '');
        });
    },

    /**
     * Меняет главный чекбокс, в зависимости от значений внутренних.
     */
    onInternalChange: function (){
        var checked = 'yes';

        $.map(this.items, function (item) {
            if (item.checkbox.getMod('checked') != 'yes') checked = '';
        });

        if(this.items.length && this.checkbox.getMod('checked') != checked){
            this.checkbox.un('change', this.onChange, this);
            this.checkbox.setMod('checked', checked);
            this.afterCurrentEvent(function () {
                this.checkbox.on('change', this.onChange, this)
            });
        }
    }
})
