BEM.DOM.decl({ name: 'b-device-targeting', baseBlock: 'b-model-block' }, {
    onSetMod: {
        js: function (){
            this.__base();

            this.__self.deviceNames = this.params.deviceNames;
            this.model
                .onField(
                    this.model.getFieldsNames('fromServer').join(' '),
                    'change',
                    this.onModelChange,
                    this)
                .on('validate', this.onValidate, this);
        }
    },


    /**
     * Когда меняется поле модели, записываем все чекнутые значения в хидден инпут
     */
    onModelChange: function (){
        var data = this.model.getData(),
            result = [];

        $.each(data, function (key, val){
            if(key != 'device_targeting' && val) result.push(key)
        });
        this.model.set('device_targeting', result);
    },

    onValidate: function (e, data){
        if (!data.isValid) alert(iget('Нельзя отключить таргетинг на всех устройствах'));
    },

    finish: function (){
        this.model.triggerField(this.model.getFieldsNames('fromServer')[0], 'change');
    }

},

{
    getText: function (ctx){
        var model = ctx.model,
            result = [],
            all = true,
            deviceNames = this.deviceNames;

        $.map(model.getFieldsNames('fromServer'), function (key){
            if(key != 'device_targeting' && model.get(key)) result.push(deviceNames[key]);
            else all = false;
        });

        return all ? iget('Все устройства') : result.join(', ');
    }

})

BEM.blocks['b-model'].register('b-device-targeting', {
    fields: {
        'other_devices': { type: 'flag', fromServer: 1, input: 1 },
        'device_targeting': { type: 'input', input: 1, toServer: 1 },
        'iphone': { type: 'flag', fromServer: 1, input: 1 },
        'android_phone': { type: 'flag', fromServer: 1, input: 1 },
        'ipad': { type: 'flag', fromServer: 1, input: 1 },
        'android_tablet': { type: 'flag', fromServer: 1, input: 1 }
    },
    validateRules: {
        device_targeting: {
            list: [
                {
                    id: 'not_empty',
                    validator: function (){
                        var _this = this,
                            valid = false;

                        $.map(this.getFieldsNames('fromServer'), function (i) {
                            if (_this.get(i)) valid = true;
                        });

                        return valid;
                    }
                }
            ]
        }
    }
})

