(function($) {
    //utility - вспомогательное поле
    //server - отправляется на сервер
    //serverName - имя для хранения на сервере
    //input - напрямую вводится пользователем

    BEM.blocks['b-model'].register('b-disabled-ips', {
        fields: {
            'disabledIps': {type: 'string', fromServer: 1, toServer: 1, input: 1}
        }
    });

    BEM.DOM.decl({name:'b-disabled-ips', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                this._modelPath = 'campaign';
                this._modelName = 'b-disabled-ips';
                this.ips = [];
                this.ipsControls = [];
                this.MAX_IPS_COUNT = this.params.MAX_IPS_COUNT || 25;
                this.initConsts();
                this.initModel();
                this.bindEvents();

            }
        },

        initConsts: function() {
           this._modelPath = 'campaign';
           this._modelName = 'b-disabled-ips';
        },

        bindEvents: function() {
            this.__base();
            this.bindTo('add', 'click', this.onAddClick);
            this.bindTo('new', 'keypress', this.onKeyPress);
        },

        start: function() {
            this.fillIpsFromModel();

        },

        onKeyPress: function(event) {
            if (event.keyCode == 13) {
                this.addIps(this.elem('new').val())
                return false;
            } else {
                return true;
            }
        },

        onAddClick: function() {
            this.addIps(this.elem('new').val())
        },

        finish: function() {
            var value = [];
            $.each(this.ipsControls, function(i, elem) {
                if (elem.getMod('checked') == 'yes') {
                    value.push(elem.val());
                }
            });

            var valueStr = value.join(', ');
            this.model.update({'disabledIps': valueStr}, this);
        },

        fillIpsFromModel: function() {
            this.elem('list').empty();
            this.ips = [];
            this.ipsControls = [];
            this.addIps(this.model.get('disabledIps'));
        },

        getIpsLength: function() {
            var length = 0;
            $.each(this.ipsControls, function(i, elem) {
                if (elem.getMod('checked') == 'yes') {
                    length++;
                }
            });
            return length;
        },

        addIps: function(value) {
            var newIP = value ? direct.utils.clearSequence(value).split(/[ \t,]+/) : [],
                ipsArray = [];

            if (this.getIpsLength() + newIP.length > this.MAX_IPS_COUNT) {
                alert(iget("Превышено допустимое количество запрещенных IP-адресов: %s", this.MAX_IPS_COUNT));
                return;
            }


            for( var i = newIP.length - 1; i >= 0 ; i-- ) {
                //убираем оставшишиеся после split'a куски с пробелами
                if (!newIP[i].replace(/\s*/, '')) {

                } else if (!direct.utils.validateIP(newIP[i])){
                    alert(iget("Неверно указан IP адрес %s", newIP[i]));
                } else {
                    // проверяем на наличие в this.ips
                    var exists = false;
                    for( var j = 0; j < this.ips.length; j++ ) {
                        if ( this.ips[j] == newIP[i] ) {
                            exists = true;
                            break;
                        }
                    }
                    if (!exists ) {
                        ipsArray.push(this.getIpHTML( newIP[i] ));
                        this.ips[this.ips.length] = newIP[i];
                        this.count++;
                    }
                    newIP[i] = null;
                }
            }

            this.elem('list').prepend(ipsArray.join(''));
            this.ipsControls = this.findBlocksInside('b-form-checkbox');
            var self = this;
            $.each(this.ipsControls, function(i, control) {
                control.on('change', function() {
                    if (this.isChecked() && self.getIpsLength() > self.MAX_IPS_COUNT) {
                        alert(iget("Превышено допустимое количество запрещенных IP-адресов: %s", self.MAX_IPS_COUNT))
                        this.delMod('checked');
                    }
                })
            })
            var newValue = [];
            for( var i = 0; i < newIP.length; i++ ) {
                if ( newIP[i] ) {
                    newValue.push(newIP[i]);
                }
            }
            this.elem('new').val(newValue.join(', '))
        },

        getIpHTML: function(str) {
            return BEM.HTML.build({
                block : 'b-disabled-ips',
                attrs: {},
                elem : 'ip',
                tag: 'span',
                content : [
                    {
                        mix: [{elem: 'ip-checkbox', block: 'b-disabled-ips'}],
                        block: 'b-form-checkbox',
                        mods: { checked: 'yes' },
                        checkboxAttrs: { value: str }
                    },
                    {
                        tag: 'span',
                        content: str
                    },
                    {
                        tag: 'br'
                    }
                ]
            });
        }


        
    }, {
        live: true,
        getText: function(ctx) {
            return ctx.model.get('disabledIps');
        },

        getButtonText: function(ctx) {
            return ctx.model.get('disabledIps') ? iget('изменить') : iget('добавить IP-адреса');
        }
    });



    
})(jQuery);
