BEM.DOM.decl('b-disconnect-wallet', {
    onSetMod: {
        js: function() {
            this.transfer = this.findBlockInside('b-money-transfer2');
            this.transfer && this.transfer.on('change-rest', this.onChangeRest, this);
            this.spin = this.findBlockOn('spin', 'b-spin');
            //кэшируем
            this.elem('spin');
            this.dropdowna = this.findBlockInside('b-dropdowna');

            this.dropdowna.getPopup().on('hide', function() {
                this.transfer && this.transfer.clear();
            }, this);

            //кэшируем элементы пока не открылся попап
            this.submit = this.findBlockInside('submit', 'b-form-button');
            this.submit && this.submit.on('click', this.onSubmit, this);
            this.cancel = this.findBlockInside('cancel', 'b-form-button');
            this.cancel && this.cancel.on('click', this.onCancel, this);
        }
    },

    /**
     * Изменился остаток неперенесенных средсвт на общем счетке
     * @param {Object} e
     * @param {Object} data
     * @param {Number} data.rest
     * @returns {BEM}
     */
    onChangeRest: function(e, data) {
        this.submit.setMod('disabled', data.rest ? 'yes' : '');
        return this;
    },
    
    onSubmit: function() {
        this.params.toTransfer != 0 && this.elem('sums').val(JSON.stringify(this.transfer.getSumsToTransfer()));
        this.elem('form').submit();
        this.submit.setMod('disabled', 'yes');
        this.cancel.setMod('disabled', 'yes');
        this.setMod(this.elem('spin'), 'visible', 'yes');
    },
    
    onCancel: function() {
        this.dropdowna._toggle();
    }
});

