(function($) {
    //utility - вспомогательное поле
    //server - отправляется на сервер
    //serverName - имя для хранения на сервере
    //input - напрямую вводится пользователем

    BEM.blocks['b-model'].register('b-dont-show', {
        fields: {
            'DontShow': {type: 'string', toServer: 1, fromServer: 1, input: 1}
        }
    });

    BEM.DOM.decl({name:'b-dont-show', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                this.domains = [];
                this.domainsControls = [];
                this.LIMIT_DOMAINS = this.params.LIMIT_DOMAINS || 1000;
                this.initConsts();
                this.initModel();
                this.bindEvents();
            }
        },

        initConsts: function() {
           this._modelPath = 'campaign';
           this._modelName = 'b-dont-show';
        },

        bindEvents: function() {
            this.__base();
            this.selectAllCbx = this.findBlockOn('select-all', 'b-form-checkbox').on('change', this.selectAll, this)
            this.bindTo('add', 'click', this.onAddClick);
        },

        selectAll: function() {
            var checked = this.selectAllCbx.getMod('checked');

            if (checked == 'yes' && this.domainsControls.length > this.LIMIT_DOMAINS) {
                alert(iget('Превышено максимально допустимое кол-во отключенных площадок.'));
            } else {
                $.each(this.domainsControls, function(i, elem) {
                    elem.setMod('checked', checked)
                });
            }
        },

        adjustSelectAll: function() {
            var checked = 'yes';
            $.each(this.domainsControls, function (i, elem) {
                if (elem.getMod('checked') != 'yes') {
                    checked = 'no';
                    return false;
                }
            });
            this.selectAllCbx.un('change', this.selectAll, this);
            this.selectAllCbx.setMod('checked', checked);
            this.afterCurrentEvent(function() {
                this.selectAllCbx.on('change', this.selectAll, this);
            }, this);


        },


        onAddClick: function() {
            this.addDontShow(this.elem('new-pages').val())
        },

        fillInputsFromModel: function() {
            this.elem('domains-list').empty();
            this.domains = [];
            this.domainsControls = [];
            this.addDontShow(this.model.get('DontShow'), true);
        },



        finish: function() {
            var value = [],
                _this = this;

            $.each(this.domainsControls, function(i, elem) {
                var val = elem.val();

                if (elem.getMod('checked') == 'yes' && !_this.dontDisableDomains(val)) {
                    value.push(val);
                }
            });

            this.model.set('DontShow', value.join(', '), this)
        },


        /**
         * Проверяет домен на принадлежность белому списку (нельзя отключить показы на нём)
         * @param {String} domain
         * @param {Boolean} [noAlert] показывать ли алерт
         * @returns {Boolean} true если domain из белого списка
         */
        dontDisableDomains: function(domain, noAlert) {
            if (domain.match(/^((m|www)\.)?((direct)\.)?(yandex|ya)\.[a-z]+$/i) ||
                domain.toLowerCase() == 'яндекс.рф' || domain.toLowerCase() == 'xn--d1acpjx3f.xn--p1ai' ||
                domain.match(/^((go|www|)\.)?mail\.ru/)) {

                !noAlert && alert(iget('Отключать показы на площадке %s нельзя.', domain));

                return true;
            }

            return false;
        },

        addDontShow: function(value, init) {
            var newPages = value ? direct.utils.clearSequence(value).split(/[ \t,]+/) : [],
                elemsHTML = [],
                _this = this;

            if (newPages.length + this.domainsControls.length > this.LIMIT_DOMAINS) {
                alert(iget('Превышено максимально допустимое кол-во отключенных площадок.'));
                return;
            }

            // оставляем только домены удовлетворяющие всем нашим условиям
            newPages = $.map(newPages, function(el) {
                el = direct.utils.stripWww(el);

                if (!direct.utils.validateHref(el)) {
                    alert(iget('Неверно указан домен:') + ' ' + el);

                } else if (!init && _this.dontDisableDomains(el)) {

                    return undefined;

                } else if ( el.match('^(\\*\\.)?' + direct.utils.commonDomainRegExp + '$') ) {
                    alert(iget('Нельзя отключать показы для доменов общего использования.'));

                } else if ( el.length >= 255) {
                    alert(iget('Превышена максимально допустимая длина домена'));

                } else {
                    // проверяем на наличие в domains
                    var exists = false;

                    for (var j = 0; j < _this.domains.length; j++) {
                        if (_this.domains[j].toLowerCase() == el.toLowerCase()) {
                            exists = true;
                            break;
                        }
                    }

                    if (!exists) {
                        elemsHTML.push(_this.getDomainHTML(el));
                        _this.domains[_this.domains.length] = el;
                    }

                    return undefined;
                }
            });
            
            this.elem('domains-list').prepend(elemsHTML.join(''));
            this.domainsControls = this.findBlocksInside({ blockName: 'b-form-checkbox', modName: 'domain', modVal: 'yes' });

            this.elem('new-pages').val(newPages.join(', '));
            this
                .setMod('select-all', this.domainsControls.length > 1 ? 'yes' : 'no')
                .adjustSelectAll();

            $.each(this.domainsControls, function(i, domain) {
                domain.on('change', _this.adjustSelectAll, _this)
            });

        },

        getDomainHTML: function(str) {
            return BEM.HTML.build({
                block : 'b-dont-show',
                attrs: {},
                elem : 'domain',
                tag: 'div',
                content : [
                    {
                        mix: ['b-dont-show__checkbox'],
                        block: 'b-form-checkbox',
                        mods: { checked: 'yes', domain: 'yes' },
                        checkboxAttrs: { value: str }
                    },
                    {
                        tag: 'span',
                        content: str
                    },
                    {
                        tag: 'br'
                    }
                ]
            });
        }

    }, {
        live: true,
        getButtonText: function() {
            return iget('задать');
        },

        getText: function(ctx) {
            return ctx.model.get('DontShow');
        }
    });




})(jQuery);

