
(function($, Lego) { 
    
Lego.block['b-dropdown-select'] = function(params) {
    Lego.block['b-dropdown'].call(this, params);

    var $this = $(this),
        options = $('.b-dd-select__option', $this),
        current = $('.b-dd-select__current', $this),
        values = [],
        input = $('.b-dd-select__hidden', $this);

    if (current.length > 0) {
        values = [current.html()];
    }

    values = values.concat($.map(options, function(v) {
        return v.innerHTML;
    }));

    $this.data('selectedIndex', 0);
    if (params.values) $this.data('value', params.values[0]);

    options.click(function(e) {
        selectOptionByHtml(this.innerHTML);
        input.val((params.values || values)[$this.data('selectedIndex')]);
        if (params.values) $this.data('value', params.values[$this.data('selectedIndex')]);

        $this
            .trigger('popupsClose.lego')
            .trigger('select', {selected: $this.data('value')});
        return true;
    });

    if (input.length > 0) {
        onHiddenChange();
        input.change(onHiddenChange);
    }

    function selectOptionByHtml(html) {
        if (current.length > 0) {
            current.html(html);
            for (var i = 0, j = 0; i < values.length; i++) {
                if (values[i] == html) {
                    $this.data('selectedIndex', i);
                } else {
                    options[j++].innerHTML = values[i];
                }
            }
        } else {
            for (var i = 0; i < values.length; i++) {
                if (values[i] == html) {
                    $this.data('selectedIndex', i);
                    break;
                }
            }
        }
    }

    function selectOptionByIndex(index) {
        if (current) {
            for (var i = 0, j = 0; i < values.length; i++) {
                if (i == index) {
                     current.html(values[i]);
                } else {
                    options[j++].innerHTML = values[i];
                }
            }
        }
        $this
            .data('value', params.values[index])
            .data('selectedIndex', index);
    }

    function onHiddenChange() {
        var value = input.val(),
            index = $.inArray(value, params.values || values);

        if (index != -1) {
             selectOptionByIndex(index);
        }
    }
};
})(jQuery, window.Lego);
