(function($) {
     BEM.DOM.decl({name:'b-edit-phrase-autobroker', baseBlock: 'b-model-block'}, {
         onSetMod : {
             js: function() {
                 var self = this;
                 self.initConsts();
                 self.initModel();
                 self.model.onField('autobroker', 'change', self.onAutobrokerChanged, self);

                 this.autobroker = this.elem('autobroker');
             }
         },

         initConsts: function() {
             this._modelPath = this.params.modelPath;
             this._modelName = 'b-phrases-list-phrase';
         },


          /*
           * Изменение флага "автоброкер" из вне
           */
          onAutobrokerChanged: function(e, data) {
              if (this.model.get('deleted') || this.model.get('delete_complete')) { return; }
              this.autobroker.prop('checked', this.model.get('autobroker') ? true : false);
          }
     }, {
         live: function() {
             this.liveBindTo('autobroker', 'click', function(e) {
                 var checked = this.autobroker.prop('checked');

                 if (!checked && !confirm(iget('Внимание! Выключение автоброкера может привести к повышенному расходу средств. Автоброкер всегда понижает заявленную вами максимальную цену клика.'))) {
                     e.preventDefault();
                     return;
                 }

                 this.model.update({ 'autobroker': +checked }, this);

             });
         }
     })

})(jQuery);


