(function($) {
    BEM.DOM.decl({name:'b-edit-phrase-keywords', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                this.initConsts();
                this.initModel();
                this.model.onField('phrase', 'change', this.updateChangedMode, this);

                this.campModel =
                    BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-view')
                        .on('save error', this.onServerSaved, this);

                this.bannerModel = BEM.blocks['i-models-manager'].get('campaign&banner:' + this.model.get('bannerId'), 'b-banners-list-banner');


                this
                    .bindTo('content', 'mouseenter', this.onMouseEnter)
                    .bindTo('content', 'mouseleave', this.onMouseLeave)
                    .bindTo('content', 'leftclick', this._toggle);
            }
        },

        initConsts: function() {
            this._modelPath = this.params.modelPath;
            this._modelName = 'b-phrases-list-phrase';
        },

        onServerSaved: function(e, data) {
            this.delMod('changed');
        },


        onSave: function() {
            this.doBlocksMethod(this.phraseMinusWord(), 'onMinusWordsChanged')
        },

        updateChangedMode: function() {
            this.setMod('changed', this.model.isFieldChanged('phrase') ? 'yes' : 'no');
       },

        _toggle : function() {
            //иницилиазируем блок с ключевиками, если он не был инициализирован раньше
            this.findBlockInside('b-phrase-minus-words');

            var popup = this.getPopup();
            return popup.isShowed()?
                popup.hide() :
                popup.showAndRestore(this.domElem, this.model, this.bannerModel.get('geo_ids'));
        },

        onMouseEnter: function() {
             this.setMod('active', 'yes');
        },

        onMouseLeave: function() {
            this.setMod('active', 'no');
        },


        getPopup : function() {
            return this._popup || (this._popup = BEM.blocks['b-edit-phrase-popup'].getInstance().on('save', this.onSave, this));
        }
    }, {
        live: true
    });
})(jQuery);



