(function($) {

var iModelManager = BEM.blocks['i-models-manager'];

BEM.DOM.decl({name:'b-edit-phrase-popup', baseBlock: 'b-popupa'}, {
    onSetMod: {
        js: function() {
            var self = this;
            self.__self.instance = self;
            self.editModel = iModelManager.get('campaign', 'b-edit-phrase-popup');
            self.campModel = iModelManager.get('campaign', 'b-campaign-view');
            self.__base();



            self.adjustBtn =
                self.findBlockInside({blockName: 'b-form-button', modName: 'value', modVal: 'adjust'})
                    .on('click', self.toggleAdjust, self);

            self.delBtn =
                self.findBlockInside({blockName: 'b-form-button', modName: 'value', modVal: 'del'})
                    .on('click', self.deletePhrase, self);

            self.okBtn =
                self.findBlockInside({blockName: 'b-form-button', modName: 'value', modVal: 'ok'})
                    .on('click', self.onSubmit, self);

            self.cancelBtn =
                self.findBlockInside({blockName: 'b-form-button', modName: 'value', modVal: 'cancel'})
                    .on('click', self.onCancel, self);

            self.on('outside-click', function(e) {
                e.preventDefault();
            });

            self.switcher = self.findBlockInside('b-form-switch').on('change', self.onSuspendedChange, self);

            self.editModel.onField('phrase', 'change', self.onPhraseChange, self);


            self.bindTo('input', 'change blur', $.proxy(self.onInputChange, self));

            BEM.blocks['b-popupa'].on('open', function(e, popup) {
                if (popup != self && self.isShowed()) {
                    self.hide();
                }
            });
            self.__self.on('open', function(e, popup) {
                if (popup != self && self.isShowed()) {
                    self.hide();
                }
            });
            self.on('show', function() {
               self.__self.trigger('open', self);
            })



        },

        'adjust': function(modName, modVal) {
            this.afterCurrentEvent(function() {
                var block = BEM.blocks['b-minus-words-list'].getInstance();
                block[modVal == 'yes' ? 'switchOn' : 'switchOff']()

            });
        },

        'type': function(modName, modVal) {
            this.delBtn.elem('text').html(modVal == 'phrase' ? iget('Удалить фразу') : iget('Удалить условие'));
        }
    },

    onSuspendedChange: function() {
        //почему-то при клику по тоглу статуса не срабатывает корректно blur на поле ввода фраз
        var pModel = this.parentModel,
            pid = pModel.get('phraseId'),
            bid = pModel.get('bannerId'),
            flag = true;

        function definedSuspendedOdDeleted(i, model) {
            if (model.get('phraseId') != pid && !model.get('deleted') && !model.get('is_suspended')) {
                flag = false;
                return false;
            }
        }

        iModelManager.eachModel(definedSuspendedOdDeleted, 'campaign&banner:' + bid + '&retargeting:*', 'b-phrases-list-phrase');

        iModelManager.eachModel(definedSuspendedOdDeleted, 'campaign&banner:' + bid + '&phrase:*', 'b-phrases-list-phrase');

        if (!!parseInt(this.switcher.val()) && flag) {
            this.switcher.val('off');
            this.afterCurrentEvent(function() { this.switcher.val("0"); }, this);
            alert(iget('Нельзя отключить последнюю фразу в объявлении'));
            return;
        }

        this.onInputChange();
        this.editModel.update({
            is_suspended: this.switcher.val()
        })
    },



    showError: function(text) {
        var self = this;
        if (!this.error) {
            this.domElem.append(BEM.HTML.build({
                block: 'b-popupa',
                mods: {
                   direction: 'fixed'
                },
                js: {
                    underMods: {
                        type: 'paranja'
                    }
                },
                mix: [{elem: 'error', block: 'b-edit-phrase-popup'}],
                content: [
                   {
                       elem: 'content',
                       content : [
                           {
                               elem: 'message',
                               content: text
                           },
                           {
                               block: 'b-form-button',
                               type: 'button',
                               content: iget('OK'),
                               mix: [{elem: 'ok', block: 'b-popupa'}]
                           }
                       ]
                   }
                ]
            }));

            this.error = this.findBlockOn('error', 'b-popupa')
                            .bindTo('ok', 'click', function() {
                                self.show(self._owner);
                                this.hide();
                            });
        } else {
            this.error.elem('message').text(text);
        }
        self.hide();
        this.error.show()
    },

    onPhraseChange: function(e, data) {
        if (data.source == this) { return; }
        this.elem('input').val(this.editModel.get('phrase'))

    },

    hide: function() {
        //нет необходимости при открытии показывать блок с уточнением - даже если он был не свёрнут в прошлый раз
        this.setMod('adjust', 'no');
        this.__base();
    },



    showAndRestore: function(owner, parentModel, geo) {
        this.parentModel = parentModel;
        this.setMod('type', this.parentModel.get('is_retargeting') ? 'retargeting' : 'phrase');
        var minusWords =
            (this.parentModel.get('minus_words') ? this.parentModel.get('minus_words') : '') +
            (this.parentModel.get('phrase_unglued_suffix') ? ' ' + this.parentModel.get('phrase_unglued_suffix') : ''),

            bid = this.parentModel.get('bannerId'),
            bannerMinusWords = iModelManager.get('campaign&banner:' + bid, 'b-minus-words').get('minus_words') || '',
            campaignMinusWords = iModelManager.get('campaign', 'b-minus-words').get('minus_words') || '';

        this.editModel.update({
            key_words: this.parentModel.get('key_words'),
            is_suspended: this.parentModel.get('is_suspended'),
            minus_words: minusWords,
            generalMinusWords: bannerMinusWords + ' ' + campaignMinusWords,
            geo: geo
        }, this);

        this.elem('input').val(this.parentModel.get('phrase'));
        this.elem('view').text(iget('Условие') + ': "' + direct.utils.addWbrs(this.parentModel.get('condition_text'), 70) + '"');
        this.elem('is_suspended').toggleClass('g-hidden', this.parentModel.get('mode') == 'low_ctr');
        this.setMod('has-suspend-toggle', this.parentModel.get('mode') == 'low_ctr' ? 'no' : 'yes');
        var href = SCRIPT + '?cmd=showCompetitors&nocid=' + this.campModel.get('cid') + '&id=' + this.parentModel.get('phraseId');
           if (this.parentModel.get('strategy_mode') == 'context') {
               href += '&from=ctx';
           }
        this.elem('competitors').attr('href', href);
        this.switcher.val(this.parentModel.get('is_suspended')+'');
        this.show(owner);


    },

    countActive: function() {

    },

    deletePhrase: function() {
        var self = this,
            allDeleted = true,
            pModel = self.parentModel,
            pid = pModel.get('phraseId'),
            bid = pModel.get('bannerId');


        function definedDelete(i, model) {
            if (model.get('phraseId') != pid && !model.get('deleted') && !model.get('is_suspended')) {
                allDeleted = false;
                return false;
            }
        }

        //если фраза отключена везде, то можем удалять если только это не единственная фраза
        if(this.parentModel.get('mode') !='active' && this.parentModel.get('mode') != 'context') {
            allDeleted = true;
            //отключить можно только фразы но не категории и не условия ретаргетинга

            iModelManager.eachModel(definedDelete, 'campaign&banner:' + bid + '&phrase:*', 'b-phrases-list-phrase');

            iModelManager.eachModel(definedDelete, 'campaign&banner:' + bid + '&retargeting:*', 'b-phrases-list-phrase');


            allDeleted && this.showError(iget('Нельзя удалить все фразы в объявлении.'));
        } else {
            iModelManager.eachModel(function(i, model) {

                if (model.get('phraseId') != pid && !model.get('deleted') && !model.get('is_suspended') &&
                    //фраза должна быть активна на поиске или в сети
                    (model.get('mode') =='active' || model.get('mode') == 'context')) {
                    allDeleted = false;
                    return false;
                }
            }, 'campaign&banner:' + bid + '&phrase:*', 'b-phrases-list-phrase');

            iModelManager.eachModel(definedDelete, 'campaign&banner:' + bid + '&phrase:*', 'b-phrases-list-phrase');

            iModelManager.eachModel(definedDelete, 'campaign&banner:' + bid + '&retargeting:*', 'b-phrases-list-phrase');

            allDeleted && this.showError(iget('В объявлении должна оставаться хотя бы одна активная фраза.'));
        }
        if (!allDeleted) {
             this.parentModel.set('deleted', 1);
             this.hide();
        }

    },

    onInputChange: function() {
        var phrase = $.trim(this.elem('input').val());
        var data = {
            minus_words: direct.utils.getMinuswordsFromPhrase(phrase),
            key_words: direct.utils.getKeywordsFromPhrase(phrase)
        };
        this.editModel.update(data, this);
        //вставляем в input облагороженное значение  DIRECT-16024
        this.elem('input').val(this.editModel.get('phrase'))
    },

    toggleAdjust: function() {
        this.toggleMod('adjust', 'yes', 'no');

    },


    /**
     * Позиционирует попап
     */
    pos : function() {
        var params = this._calcDimensions();
        this
            .setMod('direction', 'down')
            ._getUnder().show({
                left: params.ownerLeft - 10,
                top: params.ownerTop - 15
            });

        return this;

    },


    onCancel: function() {
        this.hide();
    },


    onSubmit: function() {
        if (!this.parentModel.get('is_retargeting') && direct.utils.isEmpty(this.editModel.get('key_words'))) {
            if (!this.editModel.isFieldEmpty('minus_words')) {
                this.showError(iget('Нельзя использовать в качестве ключевых фраз только минус-слова'));
                return;
            }
            this.deletePhrase();
            return;
        }
        if (!this.parentModel.get('is_retargeting') && !this.editModel.validateField('phrase')) {
            this.showError(this.editModel.getErrorsMessages('phrase'))
        } else {
            this.parentModel.update( {
                'key_words': this.editModel.get('key_words'),
                //автоматически отминусованные слова после редактирования становятся обычными
                'phrase_unglued_suffix': '',
                'unglued': 0,
                'stopword_fixated': 0,
                'minus_words': this.editModel.get('minus_words'),
                'phrase': this.editModel.get('phrase'),
                'is_suspended': this.editModel.get('is_suspended')
            }, this);
            this.hide();
        }

    }
}, {
    getInstance: function() {
        return this.instance;
    },
    live: false
});

//Модель-времянка, на момент редактирования  попапа
BEM.blocks['b-model'].register('b-edit-phrase-popup', {
   fields: {
       //фраза целиком
       'phrase': {type: 'string', toServer: 1, calcValue: function() {
           return this.get('key_words') + (this.get('minus_words') ? ' ' + this.get('minus_words') : '');
       }},
       //флаг приостановки фраз
       'is_suspended': {type: 'flag', input: 1, fromServer: 1},
       //минус-слова
       'minus_words': {type: 'string', input: 1, fromServer: 1, children: ['phrase']},
       //ключевики без минусовки
       'key_words': {type: 'string', input: 1, fromServer: 1, children: ['phrase']},
       'geo': {type: 'string'},
       // минус слова общие для объявления и кампании
       'generalMinusWords': { type: 'string' }

   },

    validateRules: {
        'phrase': {
            'rules': [
                {id: 'maxlength', name: 'maxlength', max: CAMPAIGN_MINUS_WORDS_LIMIT}
            ]
        }
    },

    errorsMessages:  {
        'phrase': {
            'maxlength': iget('Превышена допустимая длина ключевых фраз в %s символов', CAMPAIGN_MINUS_WORDS_LIMIT)
        }
    }

});



})(jQuery);

