(function($){
    var cache = {},

        saveError = iget('Ошибка при сохранении ставки. Попробуйте еще раз.'),
        loadError = iget('Ошибка при загрузке цен. Попробуйте еще раз.');

BEM.DOM.decl({block: 'b-edit-phrase-price-stat-popup', modName: 'mode', modVal: 'phrase'}, {
    onSetMod: {
        'js': function(){
            this.__self.instance = this;
            this.cacheElements();
            this.__base();
            this.mode = this.strategyModel.get('is_autobudget') ? 'autobudget' :
                this.strategyModel.get('name') == 'different_places' ?
                    this.strategyModel.get('search_strategy') != 'stop' ? 'both' : 'context' :
                    'search';
            this.bindWindow();
        }
    },

    cacheElements: function() {
        var _this = this;
        $.map(['submit', 'bid', 'price-pmax-tr', 'price-min_price-tr', 'priority', 'ctx-bid', 'ctx-coverage', 'ctx-coverage-empty'], function(name) {
            _this.elem(name);
        });
        $(['pmax', 'pmin', 'max', 'min', 'broker', 'min_price', 'coverage']).each(function(i, name) {
            _this.elem('price-' + name)
        });
        $(['100', '50', '20']).each(function(i, name) {
            _this.elem('price-' + name)
        });
    },

    showWindow: function(stat) {
        if (!stat) return;

        var _this = this;

        this.setMod('context', 'no');

        if (this.mode != 'context') {
            $(['pmax', 'pmin', 'max', 'min', 'broker', 'min_price']).each(function(i, name) {
                _this
                    .elem('price-' + name)
                    .html(({
                        min: stat.guarantee[3].bid_price,
                        max: stat.guarantee[0].bid_price,
                        pmin: stat.premium[2].bid_price,
                        pmax: stat.premium[0].bid_price
                    })[name] || stat[name])
            });
        }

        if (this.mode != 'search' && this.mode != 'autobudget') {
            $(['100', '50', '20']).each(function(i, name) {
                _this.elem('price-' + name).html(_this.noPokazometerStat(stat) ? '&mdash;&nbsp;&nbsp;&nbsp;' : stat.price_for_coverage[name])
            });
        }

        this.elem('price-pmax-tr')[stat.premium[0].bid_price == stat.premium[2].bid_price ? 'hide' : 'show']();
        this.elem('price-min_price-tr')[!stat.min_price ? 'hide' : 'show']();



        if (this.mode == 'autobudget') {
            this.elem('priority').filter('[value="' + this.parentModel.get('autobudgetPriority')  + '"]').prop('checked', true);
        } else {
            this.setMod(this.findElem(this.popup.domElem, 'rates'), 'state', stat.cbroker ? '' : 'error');

            if (this.mode != 'context') {
                this.elem('bid')
                    .val(common.number.format(stat.price));

                stat.cbroker && this.updateSearchPrice(stat.price);

            }
            if (this.mode != 'search') {
                this.elem('ctx-bid')
                    .val(common.number.format(stat.price_context));

                stat.cbroker && this.updateContextCoverage(stat.price_context);
            }

        }

    },



    bindWindow: function() {
        if (this.mode != 'autobudget') {
            if (this.mode != 'context') {
                this.bindTo('bid', 'change', this.onSearchValueChange);

            }
            if (this.mode != 'search') {
                this.bindTo('ctx-bid', 'change', this.onCtxValueChange);
            }
        } else {
            this.bindTo('priority', 'change', this.onPriorityChange)

        }

        this.bindTo('submit', 'click', this.onPopupSubmit);
    },

    setParentModel: function(parentModel) {
        this.parentModel = parentModel;
        this.tmpModel.initData(parentModel.memento());
    },


    loadStatForBid: function(callback) {
        if (cache[this.parentModel.get('id')]) {
            callback(cache[this.parentModel.get('id')]);
        } else {
            var data = {
                cmd: 'ajaxGetPrices',
                bid: this.parentModel.get('bid'),
                cid: this.parentModel.get('cid')
            }, _this = this;
            if (this.parentModel.get('ulogin')) data.ulogin = this.parentModel.get('ulogin');

            $.ajax({
                url: '/registered/main.pl',
                data: data,
                success: function(responseText) {
                    var response;
                    try {
                        response = eval('(' + responseText + ')');
                    } catch (e) {
                    }
                    if (!response || !response.result) {
                        alert(loadError);
                    } else if (response.error) {
                        alert(response.error);
                    } else {
                        $.each(response.result, function() {
                            var prices = this;
                            $.map(['strategy', 'sum_rest', 'day_budget', 'spent_today', 'timetarget_coef', 'autobudget', 'autobudget_bid'],
                                function(el){ prices[el] = response.banner[el] });
                            cache[this.id] = prices;
                            cache[this.id].prices = [];
                            cache[this.id].probs = [];
                            if (cache[this.id].pokazometer_data) {
                                for (var i =0;i < cache[this.id].pokazometer_data.shows_list.length;i++) {
                                    var row = cache[this.id].pokazometer_data.shows_list[i];
                                    cache[this.id].prices.push(+row.cost);
                                    cache[this.id].probs.push(row.cnt / cache[this.id].pokazometer_data.shows_cnt)
                                }
                            }
                        });
                    }
                    callback(cache[_this.parentModel.get('id')]);
                },
                error: function() {
                    alert(loadError);
                    callback(cache[_this.parentModel.get('id')]);
                }
            });
        }
    },


    validatePrice: function(price) {
        var currency = this.parentModel.get('currency'),
            curr = get_currency(currency);

        price = common.number.clear(price, {fail: ''});

        if (price < curr.MIN_PRICE) {
            alert(iget('Ставка должна быть не меньше %s', format_sum_of_money(currency, curr.MIN_PRICE)));
            this.elem('submit').prop('disabled', false);
            return;
        }
        if (price > curr.MAX_PRICE) {
            alert(iget('Ставка должна быть не больше %s', format_sum_of_money(currency, curr.MAX_PRICE)));
            this.elem('submit').prop('disabled', false);
            return;
        }
        return price;
    },

    onPopupSubmit: function() {
        this.elem('submit').prop('disabled', true);
        var data = {
                cmd: 'ajaxUpdatePrices',
                bid: this.parentModel.get('bid'),
                ulogin: this.parentModel.get('ulogin'),
                id: this.parentModel.get('id'),
                cid: this.parentModel.get('cid'),
                phrase: this.parentModel.get('phrase')
            },
            _this = this;


        data = this.getSaveData(data);
        if (!data) { return; }
        // update only if value changed
        if (this.tmpModel.isChanged('input')) {
            $.ajax({
                    url: '/registered/main.pl',
                    data: data,
                    dataType: 'json',
                    type: 'post',
                    success: function(response) {
                        if (response && response.error) {
                            alert(response.error);
                        } else if (!response || !response.status) {
                            alert(saveError);
                        } else {
                            _this.tmpModel.fixData();
                            _this.parentModel.update(_this.tmpModel.memento('input'));
                            var id = _this.parentModel.get('id');
                            // saving price on page
                            if (_this.mode == 'autobudget') {
                                cache[id].autobudgetPriority = _this.parentModel.get('autobudgetPriority');
                            } else {
                                if (_this.mode  != 'context') {
                                    cache[id].price = _this.parentModel.get('price');
                                }

                                if (_this.mode  != 'search') {
                                    cache[id].price_context = _this.parentModel.get('price_context')
                                }
                            }

                            _this.popup.hide();

                        }
                        _this.elem('submit').prop('disabled', false);
                    },

                    error: function() {
                        alert(saveError);
                        _this.elem('submit').prop('disabled', false);
                    }
                }
            );
        } else {
            _this.popup.hide();
            _this.elem('submit').prop('disabled', false);
        }

    },



    onPriorityChange: function() {
        this.tmpModel.set('autobudgetPriority', this.elem('priority').filter(':checked').val())
    },

    onSearchValueChange: function() {
        this.tmpModel.set('price', this.elem('bid').val());
        var priceVal = this.tmpModel.get('price');

        this.elem('bid').val(this.tmpModel.view('price'));
        if (priceVal) {
            this.updateSearchPrice(priceVal);
        }
    },

    updateSearchPrice: function(priceVal) {
        var stat = cache[this.parentModel.get('id')],
            data = direct.autobroker.calcPrice(priceVal, stat.guarantee, stat.premium, stat.larr, stat.min_price, stat.sum_rest, stat.day_budget, stat.spent_today,
            stat.strategy, stat.autobudget, stat.autobudget_bid, stat.timetarget_coef);

        this.elem('price-broker').html(common.number.format(data.price));
        stat.broker = data.price;
    },

    onCtxValueChange: function() {
        var value;

        this.tmpModel.set('price_context', this.elem('ctx-bid').val());

        //облагороженное значение
        value = this.tmpModel.view('price_context');

        this.elem('ctx-bid').val(value);

        value && this.updateContextCoverage(value);
    },

    updateContextCoverage: function(value) {
        var stat = cache[this.parentModel.get('id')],
            noPokazStat = this.noPokazometerStat(stat);

        this.elem('ctx-coverage-empty').toggleClass('g-hidden', !noPokazStat);
        this.elem('ctx-coverage').toggleClass('g-hidden', !!noPokazStat);

        if (!noPokazStat) {
            var coverage = direct.autobroker.calcContextCoverage(value  * 1e6, stat.pokazometer_data);
            this.elem('ctx-coverage').html(common.number.format(Math.floor(coverage * 100), {precision: 0}) + '%');
        }
    },

    noPokazometerStat: function(stat) {
        //фразы, по которым в показометре нет статистики кликов
        return (stat.no_pokazometer_stat == 1
            || !stat.pokazometer_data || !stat.pokazometer_data.shows_list || stat.pokazometer_data.shows_list.length < 1);
    },

    getSaveData: function(data) {
        var price, priceCtx,
            suffix = this.parentModel.get('id');
        if (this.mode == 'autobudget') {
            //DIRECT-20166 - атавизмы серверной части. непонятно зачем тут цена, но без неё не пашет
            data['val_' + suffix] = this.tmpModel.get('price');
            return this.getCommonData(this.getAutobudgetData(data));
        } else if (this.mode == 'search') {
            price = this.tmpModel.get('price');
            if (this.validatePrice(price)) {
                data['val_' + suffix] = price;
                return this.getCommonData(data)
            }
        } else {
            priceCtx = this.tmpModel.get('price_context');
            price = this.tmpModel.get('price');
            if (this.validatePrice(priceCtx) && this.validatePrice(price)) {
                data['ctx_val_' + suffix] = priceCtx;
                data['val_' + suffix] = price;
                return this.getCommonData(data);
            }

            return false;
        }

        return false;
    },

    getCommonData: function(data) {
        var suffix = this.parentModel.get('id'),
            _this = this;

        data = data || {};

        data['broker_' + suffix] = cache[_this.parentModel.get('id')]['autobroker'];
        $(['premium', 'guarantee', 'larr']).each(function(i, name) {
            data[name + '_' + suffix] = cache[_this.parentModel.get('id')][name];
        });

        return data;

    },

    getAutobudgetData: function(data) {
        data = data || {};

        var suffix = this.parentModel.get('id');
        data['autobudgetPriority_' + suffix] = this.elem('priority').filter(':checked').val();

        return this.getCommonData(data);
    },


    show: function(elem, callback) {
        var _this = this;
        this.loadStatForBid(function(stat) {
            _this.showWindow(stat);
            _this.popup.toggle(elem);
            callback();
        })

    }
});

})(jQuery);
