(function($){

BEM.DOM.decl({block: 'b-edit-phrase-price-stat-popup', modName: 'mode', modVal: 'retargeting'}, {
    onSetMod: {
        'js': function(){
            this.__self.retInstance = this;
            //кэшируем элементы
            this.cacheElements();

            this.__base();
            this.mode = this.strategyModel.get('is_autobudget') ? 'autobudget' : 'context';


            this.bindWindow();
        }
    },

    cacheElements: function() {
        var _this = this;
        $.map(['submit', 'priority', 'ctx-bid'], function(name) {
            _this.elem(name);
        })
    },

    onCtxValueChange: function() {
        this.tmpModel.set('price_context', this.elem('ctx-bid').val());
        //облагороженное значение
        var value = this.tmpModel.get('price_context');
        this.elem('ctx-bid').val(value);
    },


    showWindow: function() {

        if (this.mode == 'autobudget') {
            var value = this.parentModel.get('autobudgetPriority')
            this.elem('priority').filter('[value="' + value  + '"]').prop('checked', true);
        } else {
            this.elem('ctx-bid')
                .val(this.parentModel.view('price_context'))
        }

    },

    getSaveData: function() {
        if (this.mode == 'autobudget') {
            return {autobudgetPriority: this.elem('priority').filter(':checked').val()}
        } else {
            var price = this.tmpModel.get('price_context');
            if (this.validatePrice(price)) {
                return {'price_context': price}
            }
        }
    },

    onPopupSubmit: function() {
        this.elem('submit').prop('disabled', true);

        var changes = {},
            adgroupId = this.parentModel.get('adgroup_id'),
            phraseId = this.parentModel.get('ret_id'),
            _this = this;

        var data = this.getSaveData();
        if (!data) { return; }

        (changes[adgroupId] = { edited: {}}).edited[phraseId] = data;
        // update only if value changed
        if (this.tmpModel.isChanged('input')) {

            $.ajax({
                url: '/registered/main.pl',
                type: 'POST',
                data: {
                    'cid': this.parentModel.get('cid'),
                    'ulogin': this.parentModel.get('ulogin'),
                    'cmd': 'ajaxEditAdGroupRetargeting',
                    'json_adgroup_retargetings': $.stringify(changes)
                },
                dataType: 'json',
                success: function(data) {
                    _this.popup.hide();
                    _this.tmpModel.fixData();
                    _this.parentModel.update(_this.tmpModel.memento('input'));
                    _this.elem('submit').prop('disabled', false);
                },
                error: function(data) {
                    alert('saveError');
                    _this.elem('submit').prop('disabled', false);
                }
            });
        } else {
            _this.popup.hide();
            _this.elem('submit').prop('disabled', false);
        }
    },

    bindWindow: function() {
        if (this.mode != 'autobudget') {
            this.bindTo('ctx-bid', 'change', this.onCtxValueChange);
        } else {
            this.bindTo('priority', 'change', this.onPriorityChange)
        }

        this.bindTo('submit', 'click', this.onPopupSubmit);
    },

    show: function(elem, callback) {
        this.popup.show(elem);
        this.showWindow();
        callback();

    }
});

})(jQuery);
