(function($){

    BEM.DOM.decl('b-edit-phrase-price-stat-popup', {
        onSetMod: {
            'js': function(){
                //модель-времянка для хранения данных
                this.tmpModel = BEM.blocks['i-models-manager'].get('campaign', 'b-edit-phrase-price-stat');
                this.strategyModel =  BEM.blocks['i-models-manager'].get('campaign', 'campaign-strategy');

                this.popup = this.findBlockInside('b-popupa');
                this.popup._getUnder().un('outside-click');
            }
        },




        setParentModel: function(parentModel) {
            this.parentModel = parentModel;
            this.tmpModel.initData(parentModel.memento());
        },





        validatePrice: function(price) {
            var currency = this.parentModel.get('currency'),
                curr = get_currency(currency);

            price = common.number.clear(price, {fail: ''});

            if (price < curr.MIN_PRICE) {
                alert(iget('Ставка должна быть не меньше %s', format_sum_of_money(currency, curr.MIN_PRICE)));
                this.elem('submit').prop('disabled', false);
                return;
            }
            if (price > curr.MAX_PRICE) {
                alert(iget('Ставка должна быть не больше %s', format_sum_of_money(currency, curr.MAX_PRICE)));
                this.elem('submit').prop('disabled', false);
                return;
            }
            return price;
        },



        onPriorityChange: function() {
            this.tmpModel.set('autobudgetPriority', this.elem('priority').filter(':checked').val())
        },





        show: function(elem, callback) {
            //реализовано в сабклассах
        }
    }, {
        getInstance: function(mode){
            return (mode == 'retargeting' ? this.retInstance : this.instance);
        }
    });

})(jQuery);
