include('../../js/jq/common/format.js');
include('../../js/jq/common/parse.js');
include('../../js/jq/direct/autobroker.js');

(function($){
    var priorityMap = {
        1: iget('низкий приоритет'),
        3: iget('средний приоритет'),
        5: iget('высокий приоритет')
    };

    BEM.DOM.decl('b-edit-phrase-price-stat', {
        onSetMod: {
            'js': function(){
                var _this = this;
                this.model =  BEM.blocks['i-models-manager'].get('campaign&banner:' + this.params.bid + '&phrase:' + this.params.phraseId, 'b-edit-phrase-price-stat')

                var strategyModel = BEM.blocks['i-models-manager'].get('campaign', 'campaign-strategy');

                this.mode =
                    strategyModel.get('is_autobudget') ?
                        'autobudget' :
                        strategyModel.get('name') == 'different_places' ?
                            strategyModel.get('search_strategy') != 'stop' ? 'both' : 'context' :
                            'search';

                this.model
                    .onField('price', 'change', this.onPriceChange, this)
                    .onField('price_context', 'change', this.onPriceContextChange, this)
                    .onField('autobudgetPriority', 'change', this.onAutobudgetPriorityChange, this);

                $.map(['value', 'ctx-value'], function(el){
                    _this.bindTo(el, 'click', function(e, data) {
                        _this.setMod('loading', 'yes');
                        var popup = _this.getPopup(_this.getMod(e.data.domElem, 'mode'));
                        popup.setParentModel(_this.model);
                        popup.show(_this.elem(el), function() {
                            _this.setMod('loading', 'no');
                        });
                    })
                });
            }
        },

        getPopup: function(mode) {
            if (mode == 'retargeting') {
                return (this.retPopup || (this.retPopup = BEM.blocks['b-edit-phrase-price-stat-popup'].getInstance('retargeting')));
            }  else {
                return (this.popup || (this.popup = BEM.blocks['b-edit-phrase-price-stat-popup'].getInstance()));
            }

        },

        onPriceChange: function() {
            this.elem('value').html(format_sum_of_money( this.model.get('currency'), this.model.view('price')))

        },

        onPriceContextChange: function() {
            this.elem('ctx-value').html(format_sum_of_money(this.model.get('currency'), this.model.view('price_context')))
        },

        onAutobudgetPriorityChange: function() {
            this.elem('value')
                .add(this.elem('ctx-value'))
                .html(priorityMap[this.model.get('autobudgetPriority')])

        }




    });

    //Модель-времянка, на момент редактирования  попапа
    BEM.blocks['b-model'].register('b-edit-phrase-price-stat', {
        fields: {
            //фраза целиком
            'phrase': {type: 'string', toServer: 1, calcValue: function() {
                return this.get('key_words') + (this.get('minus_words') ? ' ' + this.get('minus_words') : '');
            }},

            //минус-слова
            'minus_words': {type: 'string', input: 1, fromServer: 1, children: ['phrase']},

            //ключевики без минусовки
            'key_words': {type: 'string', input: 1, fromServer: 1, children: ['phrase']},
            'ulogin': {type: 'string'},
            'adgroup_id': {type: 'string'},
            'bid': {type: 'string'},
            'cid': {type: 'string'},
            'id': {type: 'string'},
            'currency': {type: 'string'},
            'camp_words_text': {type: 'string'},
            'is_retargeting': {type: 'flag'},
            'AutoBroker': {type: 'flag'},
            'autobudgetPriority': {type: 'number', input: 1},
            'price_context': {type: 'number', input: 1, precision: 2},
            'price': {type: 'number', input: 1, precision: 2},
            'ret_id': {type: 'string'}

        }
    });


})(jQuery);
