(function($) {
    BEM.DOM.decl({name:'b-edit-phrase-price', modelName: 'strategy', modVal: 'autobudget'}, {
        onSetMod : {
            js: function() {
                var self = this;
                self.initConsts();
                self.initModel();
                this.model.onField('autobudgetPriority', 'change', this.onAutobudgetPriorityChange, this);
                self.elem('autobudget-link').length > 0 && self.bindTo('autobudget-link', 'click', this.togglePopup);
                self.onAutobudgetPriorityChange();
            }
        },

        getPopup: function() {
            return this.popup || (this.popup = BEM.blocks['b-phrases-list-phrase-autobudget'].getInstance())
        },

        togglePopup: function() {
            var self = this;
            if (this.getPopup().isShowed()) {
                this.popup.hide();
            } else {
                this.popup.show(this.elem('autobudget-link'), this.model.get('autobudgetPriority'), function(value) {
                    self.model.set('autobudgetPriority', value)
                });
            }
        },

        onAutobudgetPriorityChange: function(e, data) {
            if (this.model.get('deleted') ) { return; }
            var value = this.model.get('autobudgetPriority');
            this.elem('autobudget-hidden').val(value);
            this.updateTexts(value);
        },

        updateTexts: function(value) {
            var text = value == 1 ? iget('низкий') : value == 5 ? iget('высокий') : iget('средний');
            this.elem('autobudget-text').html(text);
            this.elem('autobudget-text-view') && this.elem('autobudget-text-view').html(text);
        }
    })

})(jQuery);
