(function($) {

    BEM.DOM.decl({name:'b-edit-phrase-price', modName: 'strategy', modVal: 'context'}, {
        onSetMod : {
            js: function() {
                var self = this;

                self.initConsts();
                self.initModel();
                self.bindEvents(['price_context']);

                self.model
                    .onField('price_context min_price', 'change', self.onContextPriceChanged, self)
                    .onField('autobroker', 'change', self.onContextAutobrokerChanged, self);

                self.bindTo('price-context', 'change', self.onContextPriceInput);
                self.model.on('rollback', function() {
                    self.onContextPriceChanged();
                });
                self.onContextPriceChanged();
            }
        },

        onContextPriceInput: function() {
            this.model.update({'price_context': this.elem('price-context').val()}, this);
        },

        updateContextCoverage: function() {
            var coverage = '';
            if (!this.model.get('is_retargeting')) {
                //для фраз, по которым в показометре нет статистики кликов ничего не меняем
                if (this.model.get('no_pokazometer_stat') == 1
                    || !this.model.get('pokazometer_data') || !this.model.get('pokazometer_data').shows_list || this.model.get('pokazometer_data').shows_list.length < 1) { return; }
                coverage = direct.autobroker.calcContextCoverage( this.model.get('price_context') * 1e6, this.model.get('pokazometer_data'));
                this.model.set('context_coverage', coverage * 100)
            }

         },

        onContextPriceChanged: function() {
            if (this.model.get('deleted') || this.model.get('delete_complete')) { return; }

            this.elem('price-context').val(this.model.view('price_context'));
            this.updatePhrasePriceStyles(this.model.get('price_context'));
            this.updateContextCoverage();
        },

        /*
         * Изменение флага "автоброкер" из вне
         */
        onContextAutobrokerChanged: function() {
            if (this.model.get('deleted') || this.model.get('delete_complete')) { return; }
            this.updateContextCoverage()
        }
    })

})(jQuery);


