(function($) {
    BEM.DOM.decl({name: 'b-edit-phrase-price', modName: 'strategy', modVal: 'search'}, {
        onSetMod : {
            js: function() {
                var self = this;

                self.initConsts();
                self.initModel();
                self.bindEvents(['price']);

                self.bindTo('price', 'change', function() {
                    this.model.update({'price': this.elem('price').val()}, this);
                });

                self.model
                    .onField('price min_price', 'change', self.onPriceChanged, self);

                self.model.on('rollback', function() {
                    self.onPriceChanged();
                });

                self.onPriceChanged();
            }
        },

        updateSearchPrice: function() {
            var result = direct.autobroker.calcPrice(this.model.get('price'), this.model.get('guarantee'), this.model.get('premium'), this.model.get('larr'), this.model.get('min_price'), sum_rest, day_budget, spent_today, strategy, autobudget, autobudget_bid, this.params.timetarget_coef);
            this.phrase = this.findBlockOutside('b-phrases-list-phrase');

            this.phrase
                .toggleMod('help-timetarget', 'no', 'yes', !result.place_name_without_coef || result.place_name == result.place_name_without_coef)
                .toggleMod('help-rest', 'no', 'yes', !result.truncated);

            this.phrase.elem('search-price')
                        .html(result.price > 0 && result.place_name != 'out' ? common.number.format(result.price, {exponent_delimiter: ''}) : '&ndash;')
                        .toggleClass('g-common__red', !!this.model.get('min_price') && (this.model.get('price') < this.model.get('min_price'))) ;

            this.model
                .set('search_price')
                .set('coverage', result.coverage * 100)
        },



        onPriceChanged: function() {
            if (this.model.get('deleted') || this.model.get('delete_complete')) { return; }

            this.elem('price').val(this.model.view('price'));
            this.updatePhrasePriceStyles(this.model.get('price'));
            this.updateSearchPrice();
        },



        /*
         * Изменение флага "автоброкер" из вне
         */
        onAutobrokerChanged: function(e, data) {
            if (data.source == this) { return; }
            if (this.model.get('deleted') || this.model.get('delete_complete')) { return; }
            this.updateSearchPrice()
        }
    })

})(jQuery);

