(function($) {
    BEM.DOM.decl({name:'b-edit-phrase-price', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                this.initConsts();
                this.initModel();

            }
        },

        initConsts: function() {
            this._modelPath = this.params.modelPath;
            this._modelName = 'b-phrases-list-phrase';
        },

        updatePhrasePriceStyles: function(price) {
            var curr = get_currency(BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-view').get('currency'));

            this.delMod('error');
            this.delMod('warning');
            if (price == '' || isNaN(price)) {
                this.setMod('error', 'yes');
            } else if (price < curr.MIN_PRICE) {
                this.setMod('error', 'yes');
            } else if (price >= curr.MAX_PRICE) {
                this.setMod('error', 'yes');
            } else if (price > curr.MIN_PAY) {
                this.setMod('warning', 'yes');
            }
         }
    }, {
        live: function() {
            //автобюджет
            this.liveBindTo('autobudget-link', 'click', function(e) {
                this.togglePopup(e)
            });

            //поиск  keydown нужно для DIRECT-19178  - click не всегда успевает отрабатывать
            this.liveInitOnEvent('price', 'click keydown mousedown', function() {   });

            //контекст
            this.liveInitOnEvent('price-context', 'click keydown mousedown', function() {  });

        }
    });
})(jQuery);




