//Редактирование баннера шаг 2 - редактирование ставок

(function($) {
    BEM.DOM.decl({name: 'b-edit-prices-form'}, {
        onSetMod : {
            js: function() {
                this
                    .bindTo('submit', 'click', this.onSubmit)
                    .bindTo('undo', 'click', this.onUndo)
                    .bindTo('save-draft', 'click', this.onSaveDraft);

            }
        },

        validate: function() {
            var mM = BEM.blocks['i-models-manager'],
                editModelsGroup = mM.getGroup(
                    'campaign&banner:*&phrase:*,campaign&banner:*&retargeting:*',
                    'b-phrases-list-phrase'),
                moreMax = 0,
                warnings = [],
                errorsTexts = '',
                isValid,
                errors,
                currency = mM.get('campaign', 'b-campaign-view').get('currency'),
                minPay = get_currency(currency).MIN_PAY;

            $.each(editModelsGroup, function(i, model) {
                //если с категории снят чекбокс
                isValid = model.validateModel();
                if (!isValid) {
                    errorsTexts = model.getErrorsMessagesForModel('errors');
                }

                if (!model.get('deleted')) {
                    if (model.needToValidateField('price') && model.get('price') > minPay ||
                        model.needToValidateField('price_context') && model.get('price_context') > minPay) {
                        moreMax++;
                    }
                }


            });

            if (errorsTexts) {
                 alert(errorsTexts.join(', '));
                 return false;
            }

            // предупреждаем пользователя, если ставка превышает минимальный платёж
            if (moreMax > 0) {
                warnings.push(
                    iget('Вами установлено %s больше %s',
                        moreMax + ' ' + common.inflector.pluralizeWord([iget('ставка'), iget('ставки'), iget('ставок')], moreMax),
                        format_sum_of_money(currency, minPay)));
            }


            if (warnings.length > 0) {
                return confirm(iget('Внимание!') + '\n\n' + warnings.join('\n') + '\n' + iget('Вы уверены, что хотите сохранить?'));
            }

            return true;
        },

        onUndo: function() {
            this.disableButtons(true);
            this.elem('cmd').val('gobackMultiEdit');
            this.domElem.submit();
        },

        disableButtons: function(disabled) {
            this.elem('submit')
                .add(this.elem('save-draft'))
                .add(this.elem('undo'))
                   .prop('disabled', disabled);
        },

        onSaveDraft: function(e) {
            this.elem('save-draft-hidden').val(1);
            this.validateAndSubmit();
        },

        onSubmit: function(e) {
            this.elem('save-draft-hidden').val(0);
            this.validateAndSubmit();
        },

        validateAndSubmit: function(){
            this.disableButtons(true);

            !this.validate() ? this.disableButtons(false) : this.domElem.submit();
        }
    })

})(jQuery);


