(function($) {

    BEM.DOM.decl({name:'b-edit-retargeting'}, {
         onSetMod : {
             js: function() {
                 this.bannerModel = BEM.blocks['i-models-manager'].get('campaign&banner:' + this.params.bid, this.params.modelName)
                     .onField('retargeting_conditions_id', 'change', this.updateConditions, this);
                 if (this.params.mode != 'view') {
                     this.addBtn = this.findBlockOn(this.elem('add-btn'), 'b-form-button')
                         .on('click', this.openPopup, this);
                     BEM.channel('i-retargeting-conditions').on('change', this.onConditionChange, this);
                 }

                 this.bannerModel.onInitData(this.updateConditions, this);

                 this.setMod('ext', 'hide');
             }
         },

         onConditionChange: function(e, condition) {
             this.findElem('label', 'id', condition.ret_cond_id).text(this.getShortCondName(condition.condition_name));
         },

         getShortCondName: function(name) {
            return name.length > 40 ? name.substr(0, 40) + '...' : name;
         },

         updateConditions: function() {
             this.updateConditionsHTML();

             this.dropElemCache('conditions ext-open condition-del label');
             if (this.params.mode != 'view') {
                 this.bindTo('condition-del', 'click', this.deleteCondition);
                 this.bindTo('label', 'click', this.onLabelClick);
             }

             this.bindTo('ext-open', 'click', function() {
                 this.setMod('ext', 'show');
             });
             return this;
         },

         onLabelClick: function(e) {
             var label = e.data.domElem,
                 id = this.getMod(label, 'id');
             this.openCondPopup(label, id)
         },

         deleteCondition: function(e) {
             var id = this.getMod(e.data.domElem, 'id'),
                 idsStr = this.bannerModel.get('retargeting_conditions_id');
             idsStr = BEM.blocks['b-banner-edit'].deleteIdFromString(id, idsStr);
             this.bannerModel.update({'retargeting_conditions_id': idsStr}, this);
             return this;
         },

         getConditionHTML: function(id, num, ext) {
             return BEM.HTML.build({
                 elem: 'condition',
                 mods: {'ext': ext ? 'yes' : 'no', 'id': id},
                 block: 'b-edit-retargeting',
                 content: [
                     {
                         elem: 'num',
                         block: 'b-edit-retargeting',
                         tag: 'span',
                         content: num + '. '
                     },
                     {
                         elem: 'label',
                         cls: (this.params.mode != 'view' ? 'b-pseudo-link' : ''),
                         mods: {'id': id},
                         block: 'b-edit-retargeting',
                         tag: 'span',
                         content:  direct.utils.escapeHTML(this.getShortCondName(BEM.blocks['i-retargeting-conditions'].getName(id)))
                     },
                     (this.params.mode != 'view') && { elem: 'condition-del', mods: {'id': id}, block: 'b-edit-retargeting', tag: 'span'}
                 ]
             })
         },

         getMoreHTML: function(count) {
             return BEM.HTML.build({
                  elem: 'ext-open',
                  block: 'b-edit-retargeting',
                  content: [
                      {
                          tag: 'span',
                          content: '...'
                      },
                      {
                          cls: 'b-pseudo-link',
                          tag: 'span',
                          content:  iget('ещё') + ' ' + count + ' ' + common.inflector.pluralizeWord([iget("условие"), iget("условия"), iget("условий")], count)
                      }
                  ]
              })
         },

         updateConditionsHTML: function() {
             var idsStr = this.bannerModel.get('retargeting_conditions_id');
             if (idsStr.length == 0) {
                 this.setMod('empty', 'yes');
                 return;
             }

             this.setMod('empty', 'no');
             var ids = idsStr.split(','),
                 self = this,
                 hasMore = ids.length > 4,
                 html = '';
             $.each(ids, function(i, id) {
                 html += self.getConditionHTML(id, i + 1, (i > 2) && hasMore);
                 if (hasMore && i == 2) {
                     html += self.getMoreHTML(ids.length - 3);
                 }
             });

             BEM.DOM.update(this.elem('conditions'), html);
         },

         openCondPopup: function(label, id) {
             BEM.blocks['b-get-goals-ajax'].loadGoals(function() {
                 this.getCondPopup().toggle(label, BEM.blocks['i-retargeting-conditions'].get(id))
             }, this.elem('condition', 'id', id), this);
         },

         onSaveNewCondition: function() {
             this.getPopup().toggle(this.elem('add-btn'), {bid: this.params.bid}).switchAction('list')
         },


         getCondPopup: function() {
             if (!this.condPopup) {
                 this.condPopup = BEM.blocks['b-retargeting-condition-popup'].getInstance({mode:this.params.mode})
                     .on('save-new', this.onSaveNewCondition, this);
             }
             return this.condPopup;
         },

         getPopup: function() {
             return  this.popupa || (this.popupa = BEM.blocks['b-retargeting-window'].getInstance());
         },

         openPopup: function() {
             BEM.blocks['b-get-goals-ajax'].loadGoals(function() {
                 this.getPopup().toggle(this.elem('add-btn'), {bid: this.params.bid, mode: this.params.mode}) ;
             }, this.elem('add-block'), this);

             return this;
         }
     })

})(jQuery);


