(function($, Lego) {

Lego.block['b-editable-text'] = function(params) {
    var $this = $(this),
        wrappableSiblings = $this.siblings(".b-editable-text__wrappable-sibling"),

        editableEvents = ("editableEvents" in params) ? params.editableEvents : 'click',

        wrapper = $this.add(wrappableSiblings).wrapAll("<div class='b-editable-text__wrapper'/>").parent(),

        inputAndActionButtons = $('<div class="b-editable-text__input-wrapper">' +
                                        '<input class="b-editable-text__input js-editable-text-input" type="text"/>' +
                                    '</div>' +
                                    '<ul class="b-editable-text__action-buttons">' +
                                        '<li class="b-editable-text__action">' +
                                            '<span class="b-pseudo-link js-editable-text-ok">' + iget('OK') + '</span>' +
                                        '</li>' +
                                        '<li class="b-editable-text__action">' +
                                            '<span class="b-pseudo-link js-editable-text-cancel">' + iget('отмена') + '</span>' +
                                        '</li>' +
                                    '</ul>'),
        input = inputAndActionButtons.find(".js-editable-text-input"),
        okButton = inputAndActionButtons.find(".js-editable-text-ok"),
        cancelButton = inputAndActionButtons.find(".js-editable-text-cancel"),


        initialValue = '',
        isAppended = false,
        isEditing = false;

    $this.bind(editableEvents, edit);
    cancelButton.click(cancel);
    okButton.click(submit);
    input.keydown(function(e){
        if(e.keyCode == 13) { // Enter
            e.preventDefault();
            submit();
        }
    });


    $this.data('api', {
        edit: edit,
        cancel: cancel,
        submit: submit,
        getWrapper: function() {
            return wrapper;
        },
        params: params
    });

    // callbacks are stored as property of data since it's not very convinient to
    // pass callbacks which should be executed withing the context of the given instance via onclick attribute
    // For example, in the case of b_advanced_forecast__result_table editable-text are created dynamically as user adds or removes phrases
    var f = function() {};
    var callbacks = {
        cancel: params.cancel || f,
        submit: params.submit || f,
        edit: params.edit || f,
        beforeSubmit: params.beforeSumbit || f
    };
    $this.data('callbacks', callbacks);


    function invokeCallback(callbackName) {
        var callback = $this.data('callbacks')[callbackName],
            args = Array.prototype.slice.call(arguments, 1);

        if ($.isFunction(callback)) return callback.apply(null, args);
    }

    function submit() {
        var newValue = input.val();

        if (!newValue.length) {
            alert(params.emptyTextMessage || iget('Введеное вами значение пусто'));
            return;
        }

        if (!invokeCallback('beforeSubmit', newValue)) return;

        restore();
        $this
            .text(direct.utils.hellipCut(params.phrase = newValue, hellipCutLength))
            .attr('title', newValue.length > hellipCutLength ? direct.utils.escapeHTML(newValue) : '');
        invokeCallback('submit', newValue);
        isEditing = false;
    }

    function cancel() {
        if (!isEditing) return;
        restore();
        $this.val(direct.utils.hellipCut(initialValue, hellipCutLength));
        invokeCallback('cancel');
        isEditing = false;
    }

    function restore() {
        inputAndActionButtons.addClass("g-hidden");
        $this.add(wrappableSiblings).removeClass("g-hidden");
    }

    function edit() {
        if (isEditing) return;

        $this.add(wrappableSiblings).addClass("g-hidden");
        initialValue = $.trim(params.phrase);

        if (!isAppended) {
            wrapper.append(inputAndActionButtons);
            isAppended = true;
        } else {
            inputAndActionButtons.removeClass("g-hidden");
        }

        input.val(initialValue).select();
        isEditing = true;

        invokeCallback('edit');
    }

};

})(jQuery, window.Lego);
