(function($) {
    //utility - вспомогательное поле
    //server - отправляется на сервер
    //serverName - имя для хранения на сервере
    //input - напрямую вводится пользователем

    BEM.blocks['b-model'].register('b-email-notification', {
        fields: {
            'email': {type: 'string', format: 'email', input: 1, fromServer: 1, toServer: 1},
            'sendWarn':  {type: 'flag', input: 1, fromServer: 1, toServer: 1},
            'sendAccNews':  {type: 'flag', input: 1, fromServer: 1, toServer: 1},
            'money_warning_value': {type: 'number', input: 1, fromServer: 1, toServer: 1, precision: 0},
            'warnPlaceInterval': {type: 'string', input: 1, fromServer: 1, toServer: 1},
            'offlineStatNotice': {type: 'flag', input: 1, fromServer: 1, toServer: 1},
            'email_notify_paused_by_day_budget': {type: 'flag', input: 1, fromServer: 1, toServer: 1}
        },

        validateRules: {
            'money_warning_value': {
                list: [
                    {
                        id: 'format',
                        name: 'format',
                        text:  iget('Неверное значение уровня остатка средств')
                    },
                    {
                        id: 'min',
                        name: 'min',
                        value: 1,
                        text:  iget('Неверное значение уровня остатка средств')
                   },
                   {
                       name: 'max',
                       id: 'max',
                       value: MAX_MONEY_WARNING_VALUE,
                       text:  iget('Неверное значение уровня остатка средств')
                   }
                ]
            }
        }
    });

    BEM.DOM.decl({name:'b-email-notification', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                var self = this;
                this.model = BEM.blocks['i-models-manager'].get('campaign', 'b-email-notification');

                this.emailSelect = this.findBlockInside('b-email-select')
                    .on('change', function(e, data) {
                        this.model.update({'email': data.val}, this);
                    }, this);

                this.bindEvents();
            }
        },

        bindEvents: function() {
            var self = this;
            this.__base();
            this.model.onField('sendWarn', 'change', this.onSendWarnChange, this);

        },

        finish: function() {},

        onElemSetMod: {
            'sendWarn-block': {
                'disabled': function(el, modName, modVal) {
                    this.elem('warnPlaceInterval').prop('disabled', modVal == 'yes');
                }
            }
        },


        getText: function() {
            return this.__self.getText(this);
        },

        onSendWarnChange: function() {
            this.toggleMod(this.elem('sendWarn-block'), 'disabled', 'yes', 'no', !this.model.get('sendWarn'))
        },

        provideData: function(params) {

        }

    }, {
        getText: function(ctx) {
            return ctx.model.get('email')
        }
    });


})(jQuery);
