BEM.DOM.decl({ name: 'b-email-select', baseBlock: 'b-model-block' }, {
    onSetMod : {
        js: function() {
            var _this = this;

            //кэшируем элементы до открытия попапа
            $.map(['email', 'save', 'cancel', 'email-error'], function(name) {
                _this.elem(name);
            });

            this.popup = this.findBlockInside('b-popupa')
                .on('show', function() {
                    _this.parentPopupa.on('outside-click', function(e){ e.preventDefault(); });
                    _this.elem('email').val('');
                })
                .on('hide', function(){
                    this.afterCurrentEvent(function(){
                        this.parentPopupa.un('outside-click');
                    })
                }, this);

            this.parentPopupa = this.findBlockOutside('b-popupa');

            this.model = BEM.blocks['i-models-manager'].get('campaign', 'b-email-select');
            this.bindErrorEvents();
            this.bindTo('email', 'keypress', this.onEmailInputKeyPress);
            this.bindTo('email', 'blur', function() {
                this.model.update({'email': this.elem('email').val()});
            });
            this.bindTo('save', 'click', this.onSubmit);
            this.bindTo('cancel', 'click', this.onCancel);

            this.bindTo('add-btn', 'click', function() {
                this.popup.toggle(this.elem('add-btn'))
            });

            this.bindTo('select', 'change', function() {
                this.trigger('change', { val:  this.elem('select').val()});
            })
        }
    },


    onEmailInputKeyPress: function(event) {
        if (event.keyCode == 13) {
            this.model.update({'email': this.elem('email').val()});
            this.onSubmit();
            return false;
        } else {
            this.model.update({'email': this.elem('email').val()});
            return true;
        }
    },

    onCancel: function() {
        this.popup.hide();
    },

    onSubmit: function() {
        if (this.model.validateModel()) {
            this.onNewEmail();
        }
    },

    onNewEmail: function() {
        var newEmail = this.model.get('email'),
            email = this.elem('select');

        this.popup.hide();

        if (!email.find('option[value="' + newEmail + '"]').length) {
            email.append($('<option>').html(newEmail).val(newEmail));
        }

        email.val(newEmail);

        this.trigger('change', { val: newEmail});
    }

});

BEM.blocks['b-model'].register('b-email-select', {
    fields: {
        'email': {type: 'string', format: 'email', input: 1}
    },

    validateRules: {
        'email': {
            list: [
                {name: 'format', id: 'format', text: iget('неправильный email')}
            ]
        }
    }
});

