(function($){
//Переключалка месяц/неделя для прогноза в первой помощи
BEM.DOM.decl('b-forecast-switcher', {
    onSetMod: {
        'js': function(){

            this.setCurrentType(this.params.isClient ? direct.CampOptions.get('forecast_switcher_pos') || 'week' : 'month', true);

            this
                .bindTo('month', 'click', this.onMonthSwitch)
                .bindTo('week', 'click', this.onWeekSwitch);

            BEM.blocks['b-forecast-switcher'].on('b-forecast-switcher:switch', function(e, currentType, source) {
                if (source != this) {
                    this.setCurrentType(currentType, false);
                }
            }, this)
        }
    },

    setCurrentType: function(type, triggerEvent) {
        this.elem('month').toggleClass('b-pseudo-link', type != 'month');
        this.elem('week').toggleClass('b-pseudo-link', type == 'month');
        if (triggerEvent) {
            BEM.blocks['b-forecast-switcher'].trigger('b-forecast-switcher:switch', type, this);
        }
    },

    onMonthSwitch: function() {
        this.onSwitch('month');
    },

    onWeekSwitch: function() {
        this.onSwitch('week');
    },

    onSwitch: function(type) {
        if (this.params.isClient) {
            direct.CampOptions.set('forecast_switcher_pos', type)
        }
        this.setCurrentType(type, true)
    }
});

})(jQuery);
