(function($){

BEM.DOM.decl({ name : 'b-form-input', modName : 'mode', modVal : 'tags' }, {

    onSetMod : {

        'js' : function() {

            this.__base.apply(this, arguments);

            this.on('change', this._validateTags);

            (this.popupa = this.findBlockOutside('b-popupa')) &&
                (this.popupContent = this.popupa.findBlockInside('b-banners-tags-popup-content'));

            this.camp =
                (this.popupa || {}).camp ||
                this.findBlockOutside('i-campaign-tags').__self.getByCampaignId(this.params.cid);

            // для того чтобы при наличии ошибок переданных с сервера, они не затирались клиентской валидацией
            !this.params.hasInitErrors && this._validateTags();

        }

    },

    _getNormalizedVal: function(){
        return this.val()
            .replace(/\s*,\s*/g, ',') // удаляем пробелы вокруг запятых
            .replace(/,(?=,)/g, '') // оставляем только одну запятую подряд
            .replace(/^\s*/, '') // удаляем висячие пробелы в начале
            .replace(/\s*$/, '') // удаляем висячие пробелы
            .replace(/^,/, '') // удаляем висячую запятую в начале
            .replace(/,$/, ''); // удаляем висячую запятую в конце
    },

    _validateTags : function(e) {
        var maxLength = this.params.tagMaxLength,
            maxCount = this.params.tagsMaxCount,
            maxCountForBanner = this.params.tagsMaxCountForBanner,
            singleTag = this.params.singleTag,
            tags = !singleTag ? this._getNormalizedVal() : this.val().replace(/^\s*/g, '').replace(/\s*$/, ''),
            errors = [], errorsStr,
            popupContent = this.popupContent;

        if (singleTag) {
            tags.length > maxLength && errors.push(iget('Превышена допустимая длина'));
            tags.indexOf(',') != -1 && errors.push(iget('Запятая является недопустимым символом'));
        } else {
            tags && (tags = tags.split(',')); // если tags не пустая строка (иначе получим [""] с длиной 1)

            tags.length > maxCount - this.camp.getTags().length &&
                errors.push(iget('Нельзя создавать больше %s меток', maxCount));

            popupContent && popupContent.bids &&
                $.map(popupContent.bids, function(bid){
                    tags.length + popupContent._checkedTagsCounts[bid] > maxCountForBanner &&
                        errors.push(
                            iget('Нельзя устанавливать на баннер больше %s меток', maxCountForBanner) +
                                (popupContent.bids.length > 1 ?
                                    ' ' + iget(' (превышение у объявления №%s)', bid) :
                                    '')
                        );
                });

            $.map(tags, function(el){
                el.length > maxLength &&
                    errors.push(iget('%s превышает допустимую длину',
                        '<pre>&laquo;' + direct.utils.escapeHTML(el) + '&raquo;</pre>'))
            });
        }

        errorsStr = $.map(errors, function(el){ return '<div>' + el + '</div>' }).join('') || '';

        this
            .trigger('validateTags', errorsStr)
            .setMod(this.elem('message').html(errorsStr), 'visibility', errorsStr ? 'visible' : '');

    },

    _onDeleteClick: function(){
        this.trigger('delete');

        this.destruct();
    }

}, {

    live : function() {

        this.__base();
        this.liveBindTo('delete', 'leftclick', function() {
            this._onDeleteClick();
        });

        return false;

    }

});

})(jQuery);
