/**
 * Создаем пример с демонстрацией иконок,
 * доступных через модификаторы блока
 * и выводим их фризовые урлы.
 */
var fs = require('fs'),
    exec = require('child_process').exec,
    path = require('path'),
    lego = new (require('../../../tools/lego').Lego)('blocks-desktop'),
    util = require('../../../tools/util');

function Example(cnf) {
    this.level = cnf.level;
    this.block = cnf.block;
    this.name  = cnf.name;
}

Example.prototype = {

    init: function () {

        this.tree = this._getRootFragment();

        this.mods = lego.getModsFromFileSys(this.block);

        return this;
    },

    fill: function () {

        this.mods.forEach(function(mod) {

            var modFragment = this._getModFragment(mod);

            this.tree.content.push(modFragment);

            mod.vals.forEach(function(val) {

                var urls = this._genURLs([
                        this.level,
                        this.block,
                        '_' + mod.name,
                        this.block + '_' + mod.name + '_' + val.name
                    ].join('/')),
                    itemFragment = this._getItemFragment(mod, val);

                modFragment.content.push(itemFragment);

                urls.forEach(function (url) {

                    itemFragment.content.push(this._getInfoFragment(mod, val, url));

                }, this)

            }, this)

        }, this)

        return this;
    },

    save: function () {

        util.writeFile(
            [this.level, this.block, 'examples', this.name].join('/') + '.bemjson.js',
            '//Это автогенерируемый пример. См.: examples.make.js\n' +
            '(' + JSON.stringify(this.tree, null, '    ') + ')'
        );

        return this;
    },

    _getRootFragment: function () {

        return {
            block: 'b-page',
            title: this.block,
            head: [
                { elem: 'css', url: '_' + this.name + '.css' },
                { block: 'i-jquery', elem: 'core' },
                { elem: 'js', url: '_' + this.name + '.js' }
            ],
            content: [
                {
                    block: 'b-static-text',
                    attrs: {
                        style: 'background: #BDFF70;'
                    },
                    content: 'Ниже показаны все специальные иконки, ' +
                             'доступные через модификаторы блока b-icon, и их фризовые урлы.'
                }
            ]
        }
    },

    _getModFragment: function (mod) {

        return {
            block: 'b-menu',
            mods: { layout: 'vert' },
            title: {
                elem: 'title',
                content: mod.title
            },
            content: []
        }
    },

    _getItemFragment: function (mod, val) {

        var iconMods = {};

        iconMods[mod.name] = val.name;

        return {
            elem: 'item',
            content: [
                {
                    block: 'b-icon',
                    mods: iconMods,
                    attrs: {
                        style: "margin-right: 10px;",
                        alt: val.title
                    }
                },
                '<strong>' + val.title + '</strong>'
            ]
        }
    },

    _getInfoFragment: function (mod, val, url) {

        return {
            block: 'b-text-list',
            mods: { label: 'none' },
            items: [
                'Имя: ' + this.block + '_' + mod.name + '_' + val.name,
                [
                    'URL: ',
                    {
                        block: 'b-link',
                        url: url,
                        content: url
                    }
                ]
            ]
        }
    },

    _genURLs: function (filePath) {

        var urls = [];

        ['.png', '.ico', '.svg'].forEach(function (ext) {
            var full = filePath + ext;
            path.existsSync(full) && urls.push(this.genSHA1Sum(full));
        }, this)

        return urls;
    },

    genSHA1Sum: function (filePath) {
        return [
            '//yandex.st/lego/_/',
            util.fixSha1Base64(util.sha1sumSync(filePath)),
            '.',
            filePath.split('.').pop()
        ].join('');
    }
};

(new Example({
        level:  'blocks-desktop',
        block:  'b-icon',
        name:   '00special-icons_bem'
    }))
    .init()
    .fill()
    .save();
