(function($) {

var STRIP_RE = /\s+-.*/,
    REQUEST_TIMEOUT = 1000,
    SUGGESTIONS_ON_PAGE = 10,
    AJAX_URL = '/registered/main.pl',
    NO_SUGGESTION_TEXT = iget('Нет подсказок для данного набора ключевых фраз'),
    EMPTY_WARNING_TEXT = iget('Укажите одну или несколько ключевых фраз&hellip;'),
    //следующую пустышку пришлось сделать из-за IE. Он валится при передаче вместо функции undefined
    EMPTYFUNC = ( $.browser.msie && parseFloat($.browser.version) < 9 ) ? null : undefined;


BEM.blocks['b-model'].register('b-input-keywords', {
    fields: {
        'new-phrases': {type: 'string', fromServer: 1, toServer: 1, input: 1}
    }
});

/**
 * params.charsLimit
 *      > 0     - установленный лимит
 *      = 0     - обычный ("прямой") счетчик
 *      'off'   - счетчик не отображается
 *
 */

BEM.DOM.decl({name:'b-input-keywords', baseBlock: 'b-model-block'}, {
    onSetMod: {
        js: function () {
            this.__base();

            this.suggestionsOn = this.getMod('suggestions') == 'on';
            this.toolbarOn = this.getMod('toolbar') != 'off';

            this._newPhrasesStr = '';
            this._timer = null;

            //информация о загруженных саджестах
            this._suggestions = {
                haveBefore: false,
                haveAfter: false,
                phrases: [], //подсказки текущей "страницы", для быстрой вставки
                page: 0 //"страница" (итерация) подсказок
            };

            /*  за счет адекватного кэширования i-request (проблем пока не нашел)
                можно не кэшировать дополнительно запрошенные подсказки */
            this._request = BEM.create("i-request_type_ajax", {
                type: 'post',
                url: AJAX_URL,
                dataType: 'json',
                callbackCtx: this
            });


            this.bindTo('phrases-textarea', 'change keyup', function () {
                this.trigger('change-new-phrases');
            });

            this.toolbarOn && this.bindTo('toolbar', 'click', this._onToolbarClick);
            this.suggestionsOn && this.bindTo('suggestions', 'click', this._onSuggestionsClick);

            this.on('change-new-phrases', this._onNewPhrasesChange);
        },

        //устанавливается в yes, когда не заполнены новые фразы
        empty: function (modName, modValue) {
            if (!this.suggestionsOn)
                return;

            if (modValue == 'yes') {
                this.clearSuggestions();
                this.showMessage(EMPTY_WARNING_TEXT);
            }
            else
                this.hideMessage();
        }
    },

    initConsts: function() {
        this._modelPath = 'user';
        this._modelName = 'b-input-keywords';
    },

    /**
     * Разбивает, сортирует фразы, удаляет дубли
     * @param {String|Array} phrases
     * @param {Boolean} [rmDoubles = true] Удалять дубли
     * @return {Array}
     * @private
     */
    _normalizePhrases: function (phrases, rmDoubles) {
        if (typeof phrases == 'string')
            phrases = this._splitPhrases(phrases);

        if (typeof rmDoubles == 'undefined' || rmDoubles)
            phrases = this._unique(phrases);

        return this._sortPhrases(phrases);
    },

    _onSuggestionsClick: function (e) {
        //e.target - нативный, нужно оборачивать
        var elem = this.findElem($(e.target), 'suggestion-link');
        elem && this.appendNewPhrases([elem.html()]);
    },

    /**
     * Единый обработчик на клики по кнопкам в панели
     * @param {Event} e
     * @private
     */
    _onToolbarClick: function (e) {
        //e.target - нативный, нужно оборачивать
        var elem = this.findElem($(e.target), 'button'),
            modValue = this.getMod(elem, 'type');

        switch (modValue) {
            case 'clear':
                this.clearNewPhrases();
                break;
            case 'split':
                //"упорядочить и вставить" для баннеров
                break;
            case 'order':
                this._sortPhrasesInTextarea();
                break;
            case 'sug-prev':
                this.loadSuggestions(this._suggestions.page - 1);
                break;
            case 'sug-next':
                this.loadSuggestions(this._suggestions.page + 1);
                break;
            case 'insert-all':
                /*  Добавляем все подсказки текущей итерации в новые фразы
                 *  и, если есть следующая итерация - получаем ее */
                this.appendNewPhrases(this._suggestions.phrases);
                this._suggestions.haveAfter && this.loadSuggestions(this._suggestions.page + 1);
                break;
        }
    },

    /**
     * Событие изменения списка новых фраз
     * @param {Event} e
     * @param {Object} data Дополнительные данные
     * @private
     */
    _onNewPhrasesChange: function (e, data) {
        var newPhrasesLength;

        this.model.set('new-phrases', this._toStringList(this._getNewPhrases(), false));
        newPhrasesLength = this.model.get('new-phrases');

        this.elem('phrases-field').val(this.model.get('new-phrases'));
        this.setMod('empty', newPhrasesLength ? '' : 'yes');

        this.params.charsLimit != 'off' && this._updateCounter(newPhrasesLength);

        if ( newPhrasesLength && this.suggestionsOn && ( !data || ( data && !data.noLoad )))
            this._setLoadSuggestionsTimeout();
        else
            //в случае, если список фраз пуст или запрос явно отменили
            this._clearLoadSuggestionsTimeout();
    },

    /**
     * Отмена загрузки саджестов по истчению таймату
     * @private
     */
    _clearLoadSuggestionsTimeout: function () {
        clearTimeout(this._timer);
    },

    /**
     * Загрузка саджестов с задержкой выполнения
     * Debounce не подходит, так как нет возможности отменить запускаемую функцию
     * @private
     */
    _setLoadSuggestionsTimeout: function () {
        this._timer && clearTimeout(this._timer);
        this._timer = setTimeout($.proxy(this.loadSuggestions, this), REQUEST_TIMEOUT);
    },

    /**
     * Преобразует массив фраз в строку фраз с разделителями
     * @param {Array } array
     * @param {Boolean} [newLine = true] Разделять фразы запятой и переносом строки
     * @return {String}
     * @private
     */
    _toStringList: function (array, newLine) {
        return array.join(typeof newLine == 'undefined' || newLine ? ",\n" : ',');
    },

    /**
     * Разбивает строку фраз в список
     * @param {String} phrases
     * @return {Array}
     * @private
     */
    _splitPhrases: function (phrases) {
        return $.map(phrases.split(/\s*(?:\,|\r?\n)[\,\r\n\s]*/), $.trim);
    },

    /**
     * Сортирует фразы
     * @param {Array} phrases
     * @return {Array}
     */
    _sortPhrases: function (phrases) {
        //TODO изменить после избавления от direct.utils
        return phrases.sort(this.params.sortMode == 'tr' ? direct.utils.sortTr : EMPTYFUNC);
    },

    /**
     * Удаляет дубли и сортирует по алфавиту фразы в textarea
     * Не вызывает ajax запрос на получение саджестов
     */
    _sortPhrasesInTextarea: function () {
        this.elem('phrases-textarea').val(this._toStringList(this._normalizePhrases(this.elem('phrases-textarea').val())));
    },

    /**
     * Рендерит список подсказки
     * @param {Array} list Список полученных подсказок
     * @private
     */
    _renderSuggestions: function (list) {
        var suggestionsItems = [];

        for (var i = 0, l = list.length; i < l; i++)
            suggestionsItems.push({
                block: 'b-input-keywords',
                elem: 'suggestion',
                tag: 'div',
                content: {
                    block: 'b-pseudo-link',
                    mix: [{ block: 'b-input-keywords', elem: 'suggestion-link' }],
                    content: list[i]
                },
                js: {
                    word: list[i]
                }
            });

        BEM.DOM.update(this.elem('suggestions-list'), BEM.HTML.build(suggestionsItems), function () {
            this.delMod('sug');
        }, this);
    },

    /**
     * Список новых фраз
     * @return {Array}
     */
    _getNewPhrases: function () {
        return this._normalizePhrases(this.elem('phrases-textarea').val());
    },

    /**
     * Список фраз уже присутствующих в кампании
     * @return {Array}
     */
    _getCampaignsPhrases: function () {
        ;
    },

    /**
     * Возвращает полный список фраз
     * @return {Array}
     */
    _getAllPhrases: function () {
        ;
    },

    /**
     * Обновляет счетчик фраз и подсвечивает при превышении лимита
     */
    _updateCounter: function (length) {
        var left = this.getCharsLeft(length);

        this.setMod(this.elem('counter').html(left), 'status', left < 0 ? 'overflow' : '');
    },

    /**
     * Обработка новых саджестов
     * @param {Object} data
     * @private
     */
    _processNewSuggestions: function (data) {
        this.setMod('loading', '');

        if (!data || !data.phrases || !data.phrases.length) {
            this.setMod('sug', 'no');
            this.showMessage(NO_SUGGESTION_TEXT);
            this._suggestions.haveBefore = this._suggestions.haveAfter = false;
            this._suggestions.page = 0;
            return;
        }

        //сохраняем данные о наличии доп. данных и скрываем/отображаем кнопки навигации для них
        this.elem('button_type_sug-prev').toggle(this._suggestions.haveBefore = !!data.is_something_before);
        this.elem('button_type_sug-next').toggle(this._suggestions.haveAfter = !!data.is_something_after);

        this._renderSuggestions(this._suggestions.phrases = data.phrases);
    },

    /**
     * Удаляет дубли из массива
     * @param {Array} array Исходный список
     * @return {Array} Список уникальных значений
     * @private
     */
    //TODO вынести во вспомогательный блок, когда он появится
    _unique: function (array) {
        var ret = [],
            done = {};

        for ( var i = 0, length = array.length; i < length; i++ ) {
            var id = this.stripMinusWords(array[ i ]);

            if ( !done[ id ] ) {
                done[ id ] = true;
                ret.push(array[ i ]);
            }
        }
        return ret;
    },

    /**
     * Добавляет фразы в поле ввода
     * @param {Array} list
     */
    appendNewPhrases: function (list) {
        var textarea = this.elem('phrases-textarea');
        textarea.val(textarea.val() + "\n" + this._toStringList(list, false));
        this.trigger('change-new-phrases', { noLoad: true });
    },

    /**
     * Счетчик оставшихся до лимита символов
     * Показывает отрицательное значение при превышении лимита
     * @param {Number} [length] известное актуальное значение длины строки
     * @return {Number}
     */
    getCharsLeft: function (length) {
        length = length || this._toStringList(this._getNewPhrases()).length;
        if (this.params.charsLimit == 'off')
            return undefined;
        else if (this.params.charsLimit == 0)
            return length;

        return this.params.charsLimit - length;
    },

    /**
     * Очистка полей новых фраз
     * Порождает вызов clearSuggestions
     */
    clearNewPhrases: function () {
        this.elem('phrases-textarea').val('');
        this.trigger('change-new-phrases');
    },

    /**
     * Очищает список подсказок
     */
    clearSuggestions: function (){
        this.elem('suggestions-list').html('');
        this.setMod('sug', 'no');
    },

    /**
     * Загружает подсказки
     * @param {Number} page Номер "страницы" загружаемых подсказок
     */
    loadSuggestions: function (page) {
        var phrases = this._getNewPhrases();

        //сбрасываем таймер, если загрузку иницировали не по изменению поля фраз
        this._timer && this._clearLoadSuggestionsTimeout();

        this._suggestions.page = page || 1;

        this.elem('suggestions-list').html('');

        if (phrases.length > 0) {
            this.setMod('loading', 'yes');

            //обработчик единый
            this._request.get({
                    srcPhrases: phrases.join(','),
                    iteration: this._suggestions.page - 1,
                    cmd: 'ajaxGetSuggestion',
                    brief: 'yes',
                    n: SUGGESTIONS_ON_PAGE
                }, this._processNewSuggestions,this._processNewSuggestions
            );
        }
    },

    /**
     * Скрывает сообщение в элементе suggestions
     */
    hideMessage: function () {
        this.suggestionsOn && this.elem('message').hide().html('');
    },

    /**
     * Показывает сообщение в элементе (блоке справа) suggestions
     * @param text
     */
    showMessage: function (text) {
        this.suggestionsOn && this.elem('message').html(text).show();
    },

    /**
     * Убирает из фразы минус-слова
     * @param {String} phrase Исходная фраза
     * @return {String}
     */
    //TODO вынести во вспомогательный блок
    stripMinusWords: function (phrase) {
        return phrase.replace(STRIP_RE, '');
    }

});

})(jQuery);
