(function($, Lego) {
    var iModelsManager = BEM.blocks['i-models-manager'];

    Lego.block['b-keyword-processing'] = function(params) {
        var $this = $(this),
            selectButton = $this.find('.keyword-select'),
            adjustButton = $this.find('.keyword-adjust'),
            keywordInput = $this.find('.keyword-input');

        selectButton.click(selectKeyword);
        adjustButton.click(adjustKeyword);
        var model2 = iModelsManager.get(params.modelPath, 'b-banner-edit');

        var inputName = params.inputName || 0;
        var formInstance;

        function selectKeyword(event) {
            event.preventDefault();
            //cовместимость старых версий
            var geo = params.modelPath ? model2.get('geo') : document.forms['ad'].geo.value;
            // time и key прокидываются в JS из шаблонов создания/редактирования баннера
            openPopup(keywordInput.val(), geo, time, key, "")
        }

        function adjustKeyword(event) {
            event.preventDefault();
            var geo = ( params.modelPath) ? model2.get('geo') : document.forms['ad'].geo.value;
            openPopup(keywordInput.val(), geo, "", "", 1)
        }

        function openPopup(textVal, geoVal, tmVal, keyVal, minusVal) {
            var frm = getFormInstance();
            frm.find('[name=text]').val(textVal);
            frm.find('[name=geo]').val(geoVal);
            
            frm.find('[name=tm]').val(tmVal);
            frm.find('[name=key]').val(keyVal);
            frm.find('[name=minus]').val(minusVal);
            //функция из main_js
            var win = create_standard_window("", "Words");
            frm.submit();
            if (navigator.appName == 'Netscape') {
               win.focus();
            }
        }

        function getFormInstance() {
            if (formInstance) { return formInstance; };
            formInstance = $('<form method="POST" target="Words">' +
                                        '<input type="hidden" name="cmd" value="wordstat"></input>' +
                                        '<input type="hidden" name="text"></input>' +
                                        '<input type="hidden" name="suffix"></input>' +
                                        '<input type="hidden" name="key"></input>' +
                                        '<input type="hidden" name="tm"></input>' +
                                        '<input type="hidden" name="geo"></input>' +
                                        '<input type="hidden" name="minus"></input>' +
                                        '<input type="hidden" name="name" value="' + inputName + '"></input>' +
                                   '</form>');
            formInstance.appendTo($(document.body))
            return formInstance;

        }

    }



})(jQuery, window.Lego);