(function($, Lego) {
var thisBlock = Lego.block['b-list-table'] = function(){};

thisBlock.initDescriptions = function(context) {
    var $that = $(context).closest('.b-list-table'),
        $popupTriggers = $that.find('.b-list-table__desc'),
        $text = $that.find('.b-list-table__textarea'),
        $bWindow = $that.find('.b-window').eq(0),
        $save = $bWindow.find('.b-window__button_type_save'),
        $close = $bWindow.find('.b-window__button_type_close'),
        $controls = $save.add($close).add($text),
        params = $that.find('.b-list-table__descdata').get(0).onclick(),
        currentToggle = null,  // this will point to a DOM object, not jQuery
        savingInProgress = false,
        api = $bWindow.data('api');  // reference to external API of b-window component
        
    // if b-window api is ready, we can bind our events;
    // otherwise, we have to wait until it loads completely
    if (api) {
        init();
    } else {
        $that.one('b-window_api_ready', init);
    }
    
    function init() {
        //
        // initialize api if we failed before
        // 
        api = $bWindow.data('api');
        $popupTriggers.bind('click', clck);
        
        $close.bind('click', function() {
            api.close();
        });
        $save.bind('click', save);
        
        $bWindow.bind('b-window_close', function(e) {
            if (savingInProgress) {
                //
                // no way to close window or change
                // currentToggle context while data is saving
                // at the server-side.
                //
                // Using e.preventDefault() prevents b-window component
                // from allowing the window to be closed
                //
                e.preventDefault();
            } else {
                currentToggle = null;
            }
        });
        
        $(params.container).bind('search_start', function() {
            api.close();
        });
    }
    
    function clck() {
        var $this = $(this);
        
        if (!$this.data('params')) {
            $this.data('params', this.onclick());
        }
        
        //
        // attach b-window to current link
        // 
        api.attach(this, 'left bottom', false, true);
        currentToggle == this ? api.close() : openDescWindow(this);
    }
    
    function openDescWindow(toggle) {
        currentToggle = toggle;
        $text.val($(toggle).data('params').text || '');
        
        api.show();
    }
    
    function save() {
        var data = $(currentToggle).data('params'),
            text = $text.val(),
            options = {
                cmd: params.cmd, 
                description: text
            };

        // незачем ходить на сервер, если текст не менялся совсем
        if (text === data.text) {
            api.close();
            return true;
        }
        
        savingInProgress = true;
        setControlsDisabled(true);
        options[data.idfield || 'id'] = data.id;
            
        if (params.ulogin) options.ulogin = params.ulogin;
        if (params.agencyClientList) options.agency_client_list = params.agencyClientList;
        if (params.agencyLogin) options.agency_login = params.agencyLogin;
        
        $.ajax({
            method: 'post',
            dataType: 'text',
            url: '/registered/main.pl',
            
            data: options,
            
            success: function(response) {
                if (response != '1') {
                    return onSaveError();
                }
                
                setControlsDisabled(false);
                savingInProgress = false;
                
                var p = $(currentToggle).data('params');
                p.text = text;
                $(currentToggle)
                    .data('params', p)
                    .toggleClass('disabled', !/\S/.test(text));
                    
                //
                // notify model -- FIXME
                // 
                if (params.model) {
                    var myItem = params.model.items[$popupTriggers.index(currentToggle)];
                    if (myItem) myItem.setDescription(text);
                }

                api.close();
            },
            error: onSaveError
        });
    }

    function onSaveError() {
        setControlsDisabled(false);
        savingInProgress = false;
        window.alert(iget('Ошибка при сохранении примечаний. Попробуйте еще раз.'));
    }

    function setControlsDisabled(state) {
        $controls.prop('disabled', state);
    }
    /* end descriptions */
};

thisBlock.initMassActions = function(DOMcontext, extHelpers) {
    var $M = $(DOMcontext).closest('.b-list-table').find('.b-list-table__mass').eq(0),
        $submit = $M.find('input'),
        $actions = $M.find('select'),
        selected = [],
        MAX_COUNT_FOR_OPERATION = 100, // максимальное количество кампаний с которым можно производить действия
        params = ($M.size() > 0 && $M.get(0).onclick) ? $M.get(0).onclick() : {},

        // external interface... kind of :-(
        extHelpers = $.extend({
            notifyItemsWithoutAction: function(withoutAction, params)      {return true},
            checkBeforeSubmit:        function(action, withAction)         {return true},
            notifyTooManyActions:     function(withAction)                 {return true},
            submitForm:               function(action, withAction, params) {}
        }, extHelpers || {});

    if (!params.list) return true;

    $(params.list).bind('selection_change', updateActions);

    $submit.bind('click', onSubmit);
    setDisabled(true);

    // updateActions(Direct.Storage.retrieve(params.list, 'Selectors.Selected', []));
    updateActions($.Event('selection_change'), $(params.list).data('Selectors.Selected') || []);

    function setDisabled(state) {
        $submit.add($actions).prop('disabled', state);
        $M.toggleClass('b-list-table__mass_type_disabled', state);
    };

    function getAvailableActions(selectedItem) {
        return params.actionsInfo[selectedItem].actions;
    }
    
    function getActionName(action) {
        return params.actionNames[action] || '?';
    }

    function onSubmit() {
        var withAction = [],
            withoutAction = [],
            actions,
            action = $actions.val(),
            selLength = selected.length;

        // ставим ограничение на количество кампаний, для действия "Показать статистику" DIRECT-13038
        if (action == 'showCampStat' && selLength > MAX_COUNT_FOR_OPERATION) {
            alert(iget('Количество кампаний не должно превышать %s, сейчас выбрано %s. Уменьшите количество кампаний и повторите еще раз.', MAX_COUNT_FOR_OPERATION, selLength));
            return;
        }
            
        for (var i = 0, j = selLength; i < j; i++) {
            actions = getAvailableActions(selected[i]);
            ($.inArray(action, actions) > -1 ? withAction : withoutAction).push(selected[i]);
        }
        
        if (withAction.length > 0) {
            if (withoutAction.length && !extHelpers.notifyItemsWithoutAction(withoutAction, params)) return;
            if (!extHelpers.notifyTooManyActions(withAction)) return;
            if (!extHelpers.checkBeforeSubmit(action, withAction)) return;
            extHelpers.submitForm(action, withAction, params);
        }
    }

    function getEnabledActions(selected) {
        var map = {},
            actions = [],
            itemActions;
            
        for (var i = 0; i < selected.length; i++) {
            itemActions = getAvailableActions(selected[i]);
            
            for (var j = 0; j < itemActions.length; j++) {
                if (!map[itemActions[j]]) {
                    map[itemActions[j]] = true;
                    actions.push(itemActions[j]);
                }
            }
        }
        
        return actions;
    }
    
    function updateActions(e, extra) {
        var sel = parseExtraData(extra),
            enabledActions = getEnabledActions(sel);

        $actions.html('');
        
        for (var i = 0; i < enabledActions.length; i++) {
            $actions.append(
                $('<option/>')
                    .val(enabledActions[i])
                    .html(getActionName(enabledActions[i], params))
            );
        }
        
        if (!enabledActions.length) {
            $actions.append(
                $('<option/>')
                    .html(params.emptyText || '-----')
            );
        }
        
        setDisabled(!enabledActions.length);
        selected = sel;
    }

    function parseExtraData(eventObj) {
        if (eventObj.selected) {
            selected = $.grep(selected, function(v) {
                if (v >= eventObj.indexes[0] && v <= eventObj.indexes[eventObj.indexes.length - 1]) return false;
                return true;
            });
            
            selected = selected.concat(eventObj.selected);
        } else {
            selected = eventObj;
        }
        return selected;
    }

};

thisBlock.fixWidths = function($this) {
    var topCells = $('tr.b-list-table__tr:eq(0) td.b-list-table__td', $this), // td'шки сверху, нужно чтобы фиксировать ширину таблицы

        offsetWidth = $this[0].offsetWidth,
        widths = topCells.map(function() {
            return !$.support.boxModel ? this.offsetWidth + 'px' : this.offsetWidth / offsetWidth * 100 + '%'; 
        });
    // фиксируем лэйаут с текущими ширинами (рефлоу сильно быстрее)
    if ($this.css('tableLayout') != 'fixed') {
        // $this.css('tableLayout', 'fixed');
        // FIX DIRECT-22279
//        $this.css('width', offsetWidth + 'px');
        $this.addClass('b-list-table_fixed');
        topCells.each(function(index) {
            this.style.width = widths[index];
        });
    }
    // $this.css('width', 'auto');
};

thisBlock.getHltBlocks = function(cache, row, index) {
    if (!cache[index]) {
        cache[index] = $('.hlt', row);
    }
    
    return cache[index];
};

thisBlock.getOriginalValues = function(cache, row, index) {
    if (!row.data('highlight.original')) {
        var hltBlocks = this.getHltBlocks(cache, row, index);
        row.data('highlight.original', hltBlocks.map(function(){return this.innerHTML}));
    }
    
    return row.data('highlight.original');
};

})(jQuery, window.Lego);
