(function($){
    var MOSCOW_ID = 213;

    BEM.DOM.decl('b-map-page', {
        onSetMod: {
            'js': function(){
                this.cities = this.params.cities || {};
                this.balloonData = this.params.data || [];
                this.counterStart = this.params.counterStart || 0;
                this.currentCityId = this.params.currentCityId || MOSCOW_ID;
                this.maxDefaultZoom = 15;
                this.init();
            }
        },

        init: function(){
            var self = this;
            ymaps.ready(function () {
                self.initMap();
            });
        },

        initMap: function() {
            this.currentLink = null;
            this.cityBounds = {};
            this.map = new ymaps.Map(this.elem('map-container').get(0), {
                center: [55.74954, 37.621587],
                zoom: 10
            });
            this.map.controls.add("typeSelector")
                .add("smallZoomControl")
                .add("mapTools")
                .add("scaleLine");
            this.map.behaviors.enable("ruler");
            this.initMapData();

            this.initEvents();
            this.showCity(this.currentCityId);
        },


        //делаем "ромашку" для объектов, попавших в одну точку
        initMapData: function() {
            this.placemarks = {};
            this.placemarksArray = [];
            for(var i = 0; i < this.balloonData.length; i++){
                if(this.balloonData[i].geoId && this.balloonData[i].coords[0] && this.balloonData[i].coords[1]){
                    this.setCityBounds(this.balloonData[i].geoId
                        , this.balloonData[i].coords[0], this.balloonData[i].coords[1]
                    );
                    var cnt = this.counterStart + i;
                    var placemark = new ymaps.Placemark(
                        [this.balloonData[i].coords[1], this.balloonData[i].coords[0]],
                        {
                            iconContent: '<strong>' + cnt + '</strong>',
                            balloonContent: this.getBalloonContent(i),
                            balloonOptions: {'maxWidth': 300, 'maxHeight': 600}
                        },
                        {
                            preset: "twirl#nightIcon"
                        }
                    );

                    placemark.name = cnt;
                    placemark.cityId = this.balloonData[i].geoId;

                    placemark.events.add('balloonopen', this.onBalloonOpen, this);
                    placemark.events.add('balloonclose', this.onBalloonClose, this);

                    this.placemarks[cnt] = placemark;
                    this.placemarksArray.push(placemark);


                }
            }
            this._addBusinesses();
        },

        _addBusinesses: function () {
            var businesses, i, l;

            businesses = this.placemarksArray;

            for (i = 0, l = businesses.length; i < l; i++) {
                this._addGeoObject(businesses[i], i, businesses);
            }

            // первые результаты должны были сверху
            for (i = businesses.length - 1; i >= 0; i--) {
                this.map.geoObjects.add(businesses[i]);
            }
        },


        _addGeoObject: function (geoObject, index, businesses) {
            var i, l, offset;

            //рисуем ромашку
            for (i = index - 1, l = businesses.length - 1; i >= 0; i--) {
                offset = geoObject.options.get('iconImageOffset');
                geoObject.options.set('iconImageOffset', [
                    offset[0] + Math.sin(Math.PI * 2 / 5 * (l - i)) * 20,
                    offset[1] + Math.cos(Math.PI * 2 / 5 * (l - i)) * 20
                ]);
                break;
            }

        },


        initEvents: function() {
            //кэшируем элементы дропдауна
            this.elem('city-link');
            this.elem('city-link-selected');

            this.bindTo('city-link', 'click', function(e) {
                this.showCity(this.getMod(e.data.domElem, 'link'));
                this.dropdowna._toggle();
            });

            this.dropdowna = this.findBlockInside('b-dropdowna');

            this.bindTo('map-size-control', 'click', this.changeSize);

            this.bindTo('banner-link', 'click', function(e) {
                this.showOnMap(this.getMod(e.data.domElem, 'id'));
            })
        },

        changeSize: function() {
            if (this.getMod('mode') == 'half') {
                this.setMod('mode', 'full');
                this.elem('map-size-control').html(iget('Маленькая карта'))
            } else {
                this.setMod('mode', 'half');
                this.elem('map-size-control').html(iget('Большая карта'))
            }

            this.map.container.fitToViewport();
        },

        showCity: function(cityId, notCloseBalloon) {
            if (!notCloseBalloon) {
                this.map.balloon.close();
            }
            if (this.elem('city-link-selected')) {
                this.elem('city-link-selected').html(this.cities[cityId]);
            }
            this.currentCityId = cityId;
            if (!this.cityBounds[cityId]) {
                this.map.setCenter([55.76, 37.64], 2);
                return;
            }

            // adjust map bounds
            var dx = (this.cityBounds[cityId]['rightlong'] - this.cityBounds[cityId]['leftlong']) * 0.15;
            var dy = (this.cityBounds[cityId]['toplat'] - this.cityBounds[cityId]['bottomlat']) * 0.4;

            this.map.setBounds([
                [this.cityBounds[cityId]['bottomlat'] - dy/2, this.cityBounds[cityId]['leftlong'] - dx],
                [this.cityBounds[cityId]['toplat'] + dy, this.cityBounds[cityId]['rightlong'] + dx]
            ]);
            if (this.map.getZoom() > this.maxDefaultZoom) {
                this.map.setZoom(this.maxDefaultZoom);
            }
        },

        setCityBounds: function(geoId, clong, clat) {
            if(!this.cityBounds[geoId]){
                this.cityBounds[geoId] = {
                    'leftlong': clong,
                    'toplat': clat,
                    'rightlong': clong,
                    'bottomlat': clat
                };
            } else {
                if(this.cityBounds[geoId]['leftlong'] > clong){
                    this.cityBounds[geoId]['leftlong'] = clong;
                } else if(this.cityBounds[geoId]['rightlong'] < clong){
                    this.cityBounds[geoId]['rightlong'] = clong;
                }

                if(this.cityBounds[geoId]['toplat'] < clat){
                    this.cityBounds[geoId]['toplat'] = clat;
                } else if(this.cityBounds[geoId]['bottomlat'] > clat){
                    this.cityBounds[geoId]['bottomlat'] = clat;
                }
            }
        },

        getBalloonUrls: function(id) {
            var url = '';
            if (this.balloonData[id].vcard) {
                url += '<a target="_blank" href="' + this.balloonData[id].vcard + '">' + iget('Адрес и телефон') + ' </a>';
            }

            if (this.balloonData[id].domain) {
                if (this.balloonData[id].vcard) {
                    url += '&nbsp;&middot;&nbsp;';
                }

                url += this.balloonData[id].domain;
            }

            return '<span class="url">' + url + '</span>';
        },

        getBalloonContent: function(id) {
            return BEM.HTML.build({
                'block': 'b-balloon',
                content: [
                    {
                        block: 'b-balloon-title',
                        content: this.balloonData[id].address
                    },
                    {
                        block: 'b-balloon-location',
                        content: this.balloonData[id].country + ', ' + this.balloonData[id].city
                    },
                    {
                        block: 'b-ad',
                        content: [
                            {
                                block: 'b-ad-link',
                                content: {
                                    tag: 'a',
                                    attrs: {
                                        href: this.balloonData[id].href,
                                        target: '_blank'
                                    },
                                    content: this.balloonData[id].title
                                }
                            }
                        ]

                    },
                    {
                        content: this.balloonData[id].text
                    },
                    {
                        content: this.getBalloonUrls(id)
                    }
                ]
            });
        },

        scrollToMap: function() {
            var offsetTop = this.domElem.offset().top;
            if (document.body.scrollTop > offsetTop) document.body.scrollTop = offsetTop;
        },

        showOnMap: function(id) {
            if (this.currentCityId != this.placemarks[id].cityId) {
                this.showCity(this.placemarks[id].cityId);
            }
            if (this.placemarks[id]) {
                this.scrollToMap();
                this.placemarks[id].balloon.open()
            } else {
                alert(iget('Ошибка: объекта %s нет на карте'));
            }
        },

        onBalloonOpen: function(e) {
            var target = e.originalEvent.target;
            if (this.currentCityId != target.cityId) {
                this.showCity(target.cityId, true);
            }
            this.setBannerSelected(target.name, true);
        },

        onBalloonClose: function(e) {
            var target = e.originalEvent.target;
            this.setBannerSelected(target.name, false);
        },

        setBannerSelected: function(id, selected) {
            this.setMod(this.elem('banner', 'id', ''+id), 'selected', selected ? 'yes' : 'no')
        }
    });

})(jQuery);
