(function($) {

var ajaxUrl = '/registered/main.pl',
    extractDateRE = /(\d{4})-(\d{2})-(\d{2})\s(\d{2}):(\d{2}):(\d{2})/, //не нашлось что-то готовое получше
    ERROR = iget('Произошла ошибка!'),
    SEND_OK_TEXT = iget('Фразы отправлены на проверку'),
    EMPTY_CAMPS_TEXT = iget('Нет выбранных кампаний для поиска'),
    EMPTY_PHRASES_TEXT = iget('Не указаны ключевые фразы'),
    monthsNames = ['', 'января', 'февраля', 'марта', 'апреля', 'мая', 'июня',
                'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря'];


BEM.DOM.decl('b-media-doubles', {

    onSetMod: {

        'js' : function() {
            this.request = BEM.create("i-request_type_ajax", {
                url: ajaxUrl,
                type: 'POST',
                cache: false,
                dataType: 'json',
                callbackCtx: this
            });

            this._phrases = [];
            this._clipboard = null;

            this.results = null;
            this.requests = [];

            this.blockKeywords = this.findBlockInside('b-input-keywords');

            //кэшируем элементы (для использования в попапе)
            this.elem('clipboard-button message-copy');

            this.popup = this.findBlockInside('popup', 'b-popupa')
                .on('hide', function () {
                        this.elem('single-phrases double-phrases').html('');
                        this._phrases = [];
                        this._clipboard.hide();
                        this.unbindFromWin('resize');
                    }, this)
                .on('outside-click', function(e) {
                    e.preventDefault();
                })
            ;

            this.bindTo('button-search', 'click', this._searchDoubles);

            this.findBlockInside('pane', 'b-tabbed-pane').on('current', this._onPanelSwitch, this);

            //live привязка к кликам на иконке удаления фразы из списка фраз без дублей в попапе
            this.__self.liveBindTo('delete', 'leftclick', function (e) {
                this._deletePhrase($(e.target));
            });

            //live привязка к кликам на запросе для показа списков
            this.__self.liveBindTo('result-date', 'leftclick', function (e) {
                this._getKeywords($(e.target));
            });
        }

    },

    /**
     * Скрывает (плавно, через transition) фразу, удаляет ее из списка фраз и из DOM дерева
     * @param elem
     * @private
     */
    _deletePhrase: function (elem) {
        //нам нужна не иконка, а "фраза"
        var item = elem.parent();

        //убираем фразу из переменной со списком для копирования
        this._phrases.splice(item.index(), 1);

        this.setMod(item, 'hidden', 'yes');

        //_hidden_yes скрывает фразу с transition-duration = 200ms
        setTimeout($.proxy(function () {
            item.remove();
            //обновить позицию флеш кнопки
            this._clipboard.reposition();
        }, this), 300);
    },

    _onLoadedResults: function(){
        var date,
            dateMatches,
            result = {
                block: 'b-list',
                mix: [{ block: 'b-media-doubles', elem: 'result-list' }],
                content: []
            }
        ;

        this.un('resultsLoaded');

        for (var i = 0, l = this.results.length; i < l; i++) {
            dateMatches = this.results[i].create_time.match(extractDateRE);

            date = dateMatches[3] + ' ' + monthsNames[+dateMatches[2]] + ' ' + dateMatches[1]
                + ' в ' + dateMatches[4] + ':' + dateMatches[5];

            //собираем 2 списка фраз (новые и дубли)
            result.content.push({
                elem: 'item',
                content: [
                    this.results[i].status == 'Done' &&
                        {
                            block: 'b-pseudo-link',
                            mix: [{
                                block: 'b-media-doubles',
                                elem: 'result-date',
                                mods: {
                                    done: 'yes',
                                    empty: !this.results[i].doubles_count ? 'yes' : ''
                                }
                            }],
                            content: date,
                            tag: 'span',
                            js: {request: this.results[i].request_id}
                        },
                    this.results[i].status != 'Done' &&
                        {
                            elem: 'result-date',
                            content: date,
                            tag: 'span',
                            js: {request: this.results[i].request_id}
                        },
                    {
                        elem: 'result-status',
                        mods: {
                            done: this.results[i].status == 'Done' ? 'yes' : '',
                            empty: !this.results[i].doubles_count ? 'yes' : ''
                        },
                        content: ' ' + (
                            this.results[i].status == 'New' ?
                                '&mdash; ' + iget('обрабатывается') + ' ' + iget('(заявка  %s в очереди)', this.results[i].queue_num ) :
                                this.results[i].status == 'Failed' ?
				                '&mdash; ' + iget('ошибка, не может быть обработан') :
	                        this.results[i].doubles_count  ?
                                    '(' + iget('найдено дублей: %s', this.results[i].doubles_count) + ')' :
                                    ''),
                        tag: 'span'
                    }
                ]
            });
        }

        this.elem('results-container').html(BEM.HTML.build(result));

        this.setMod(this.elem('spin', 'type', 'results'), 'hidden', 'yes');
    },

    /**
     * Собираем "свой" буфер обмена, на основе zeroclipboard
     * Свой - потому что не удалось адекватно проинициализировать и использовать
     * в попапе текущую версию i-clipboard
     * @private
     */
    _buildClipboard: function () {
        var clipboard = BEM.blocks['i-clipboard__zeroclipboard'].get(),
            styles = {zIndex: 33000};

        //в ИЕ есть косяк с позиционированием флеш кнопки - пока не понял с чем связан
        if ($.browser.msie && parseFloat($.browser.version) < 9)
            $.extend(styles, { marginTop: '-14px', marginLeft: '-8px' });

        clipboard.addEventListener('mousedown', $.proxy(function() {
            clipboard.setText(this._phrases.join(",\n"));

            this.delMod(this.elem('message-copy'), 'hidden');

            setTimeout($.proxy(function () {
                this.setMod(this.elem('message-copy'), 'hidden', 'yes');
            }, this), 2000);
        }, this));

        clipboard.glue(this.elem('clipboard-button')[0], undefined, styles);
        clipboard.show();

        this._clipboard = clipboard;
    },

    _onPanelSwitch: function (e) {
        if (e.block.getTab().index(e.block.currentTab) != 1) {
            //outside-click для попапа отменен, поэтому при переключении вкладки нужно его скрыть
            this.popup.hide();
            return;
        }

        //загрузка результатов делается 1 раз, при первом переключении на "Результаты"
        if (!this.results) {
            this.setMod(this.elem('spin', 'type', 'results'), 'hidden', '');
            this.on('resultsLoaded', this._onLoadedResults);
            this.loadResults();
        }
    },

    _onWinResize: function () {
        //позиционируем флеш кнопку
        this.popup.isShowed() && this._clipboard.reposition();
    },

    _searchDoubles: function() {
        var data = {
                cmd: 'ajaxSaveSearchDoublesOrder',
                cid: this.findBlockInside('campaigns-list', 'b-campaigns-list').checkedCamps.join(','),
                words: this.blockKeywords.model.get('new-phrases'),
                ulogin: this.params.ulogin
        };

        //если недостаточно данных для запроса - сообщаем об этом, запрос не делаем
        if (!data.cid && this.showMessage(EMPTY_CAMPS_TEXT) || !data.words && this.showMessage(EMPTY_PHRASES_TEXT)) return;

        this.setMod(this.elem('spin', 'type', 'search'), 'hidden', '');

        this.request.get(data, function (result) {
                this.setMod(this.elem('spin', 'type', 'search'), 'hidden', 'yes');

                if (result && result.ok) {
                    this.blockKeywords.clearNewPhrases();

                    this.findBlockInside('campaigns-list', 'b-campaigns-list').multiChange('');

                    this.showMessage(SEND_OK_TEXT);
                    this.results = false;
                } else
                    this.showMessage(result.error || ERROR);
            }
        );
    },

    /**
     * Получение (с кэшированием) и отображение списков фраз по запросу
     * @param elem
     * @private
     */
    _getKeywords: function(elem) {
        var request = this.findBlockInside(elem, 'b-pseudo-link').params.request;

        if (!this.hasMod(elem, 'done'))
            return;

        if (!this.requests[request]) {
            this.request.get({
                    cmd: 'ajaxGetSearchDoublesInfo',
                    request_id: request,
                    ulogin: this.params.ulogin
                }, function (data) {
                    if (!data) {
                        this.showMessage(ERROR);

                        return;
                    }

                    this.requests[request] = data.result;

                    this._showKeywords(elem, request);
                }
            );
        } else
            this._showKeywords(elem, request);
    },

    _showKeywords: function(elem, request) {
        var r = this.requests[request],
            d = [];

        this.elem('count', 'type', 'single').html(r.single_phrases.length);
        this.elem('count', 'type', 'double').html(r.double_phrases.length);

        for (var i = 0, l = r.single_phrases.length; i < l; i++) {
            this._phrases.push(r.single_phrases[i].phrase);

            d.push({
                block: 'b-media-doubles',
                elem: 'phrase',
                content: [
                    r.single_phrases[i].phrase,
                    {
                        block: 'b-ico',
                        mix: [
                            { block: 'b-media-doubles', elem: 'delete' }
                        ],
                        mods: {'is-bem': 'yes'},
                        tag: 'img',
                        attrs: {src: '/i/vcard-delete.gif'}
                    }
                ]
            });
        }

        BEM.DOM.update(this.elem('single-phrases'), BEM.HTML.build(d), function (e) {
            BEM.blocks['b-popupa'].trigger('showPopup', elem);

            this.popup.show(elem);
            this._clipboard || this._buildClipboard();
            this._clipboard.show(); //позиционируем флеш кнопку
            this.bindToWin('resize', this._onWinResize);

        }, this);

        d = [];

        for (var i = 0, l = r.double_phrases.length; i < l; i++) {
            d.push({
                block: 'b-media-doubles',
                elem: 'phrase',
                content: r.double_phrases[i].phrase
            });
        }


        BEM.DOM.update(this.elem('double-phrases'), BEM.HTML.build(d));
    },

    hideMessage: function () {
        this.setMod(this.elem('message'), 'hidden', 'yes');
    },

    showMessage: function (text) {
        this.delMod(this.elem('message').html(text), 'hidden');

        setTimeout($.proxy(function () {
            this.hideMessage();
        }, this), 4000);

        return true;
    },

    //первичная загрузка результатов
    loadResults: function () {
        this.request.get({cmd: 'ajaxGetSearchDoublesRequestList', ulogin: this.params.ulogin}, function (result) {
                result && (this.results = result) && this.trigger('resultsLoaded');
            }
        );
    }

})
})(jQuery);
