(function($){
    var MAX_ERROR_MESSAGES = 3,
        iModelsManager = BEM.blocks['i-models-manager'];


    BEM.DOM.decl({name:'b-mediaplan-edit-validate', baseBlock: 'i-banner-edit-validate'}, {
        onSetMod: {
            'js': function(){
                var _this = this;
                this.isEasy = +this.params.isEasy;
                this.isNewBlock = this.params.isNewBlock;
                this.enableValidation = !this.params.disableValidation || this.params.disableValidation == '0';
                this.__base();

                this.bindTo('submit', 'click', this.onSubmit)
                    .bindTo('back', 'click', this.onBack);
            }
        },


        disableButtons: function(disabled) {
            var disableState = disabled;

            this.elem('submit').prop('disabled', disableState);
            this.elem('back').prop('disabled', disableState);
        },

        onSubmit: function() {
            var _this = this;
            this.loadedIndex = 0;
            iModelsManager.eachModel(function(i, model) {
                _this.loadedIndex++;
                model
                    .on('split-phrases-loaded', {model: model}, _this.onModelSplited, _this)
                    .trigger('split-phrases');
            }, 'campaign&banner:*', 'b-banner-edit');


        },


        onModelSplited: function(e) {
            var model = e.data.model;
            model.un('split-phrases-loaded');
            this.loadedIndex--;
            this.splitedCounter--;


            if (this.loadedIndex == 0) {
                if (this.isEasy) {
                    //в лёгкой ПП нет единых минус слов на баннер/кампанию
                   this.onPhrasesChecked();
                } else {
                    this.checkPhrases();
                }
            }
        },

        checkPhrases: function() {
            var isChanged = false,
                params = { cid: this.cid, bids: [], ulogin: this.ulogin, cmd: 'ajaxCheckBannersMinusWords' },
                _this = this;

            iModelsManager.eachModel(function(i, model) {
                var minusWordsModel = model.getChildModel('b-minus-words');

                if (model.isFieldChanged('all_phrases') || minusWordsModel.isFieldChanged('minus_words')) {
                    var bid = model.get('bid'),
                        minusWords = minusWordsModel.get('minus_words');

                    isChanged = true;

                    params.bids.push(bid);
                    params['json_minus_words-' + bid] = JSON.stringify(BEM.blocks['i-utils'].minusWordsStringToArray(minusWords));
                    params['json_key_words-' + bid] = JSON.stringify(model.get('all_phrases').split(','));
                }
            }, 'campaign&banner:*', 'b-banner-edit');

            if (isChanged) {
                params.bids = params.bids.join(',');

                this.submitDisable(true);
                BEM.blocks['b-minus-words'].ajaxCheck(params,
                    function(errors) {
                        _this.submitNotification(false);
                        if (!errors || !errors.problem || errors.ok || errors.problem && confirm(errors.problem)) {
                            _this.onPhrasesChecked();
                        }
                        _this.submitDisable(false);
                    })
            } else {

                this.onPhrasesChecked();

                _this.submitDisable(false);
            }
        },

        onPhrasesChecked: function() {
            this.addPrasesFields();
            if (this.checkNotEmpty()) {
                this.elem('form').submit();
            }
        },

        addPrasesFields: function() {
            var _this = this;
            iModelsManager.eachModel(function(i, model) {
                var value = [],
                    bid = model.get('bid');

                    iModelsManager.eachModel(function(j, phraseModel) {
                        value.push(phraseModel.get('phrase') + '::' + (phraseModel.get('id') || 0) + '::' + phraseModel.get('numword'))
                    }, 'campaign&banner:' + bid + '&type:*&phrase:*', 'b-mediaplan-form-phrase-splited', 1);

                 _this.elem('phrases', 'bid', bid).val(value.join(','))

            }, 'campaign&banner:*', 'b-banner-edit');

        },


        onBack: function() {
            this.disableButtons(true);
            this.elem('cmd').val((this.isNewBlock ? 'create' : 'show' ) + 'Mediaplan');
            this.elem('form').submit();
        },

        checkNotEmpty: function() {
            if (!this.enableValidation) return true;

            var isValid = true;

            iModelsManager.eachModel(function(id, model) {
                isValid = model.validateModel(1) && isValid;
            }, 'campaign&banner:*', 'b-banner-edit');

            BEM.blocks['b-banner-edit'].trigger('errors.reset');
            return isValid;
        }
    });


})(jQuery);
