(function($){
//Редактирование медиаплана - разбитая фраза
    var iModelsManager = BEM.blocks['i-models-manager'];

BEM.DOM.decl('b-mediaplan-form-phrase-splited', {
    onSetMod: {
        'js': function(){
            this.model = iModelsManager.get(this.params.modelPath, this.__self.getName())
                .onField('phrase', 'change', function(e) {
                    this.elem('input').val(this.model.get('phrase'));
                    this.updateCounter();
                }, this);

            this.bannerModel = iModelsManager.get(this.params.bannerModelPath, 'b-banner-edit');

            iModelsManager.onDelete(this.params.modelPath, this.__self.getName(), this.onModelDeleted, this);
            this
                .bindTo('delete', 'click', this.onDelete)
                .bindTo('input', 'change', this.onInput)
                .bindTo('input', 'keyup change', this.updateCounter)
                .bindTo('adjust', 'click', this.onAdjust)
                .bindTo('select', 'click', this.onSelect);

            this.updateCounter();
        }
    },

    onInput: function(e) {
        var isNewPhrase = this.getMod('new'),
            phrase = $.trim(this.elem('input').val());
        if (direct.utils.isEmpty(phrase)) {
            this.onDelete();
            return;
        }
        this.model.update({'phrase': phrase, can_delete: isNewPhrase ? 1 : this.model.get('can_delete')});
    },

    updateCounter: function() {
        var phrase = $.trim(this.elem('input').val());
        this.elem('counter').text(4096 - phrase.length);
    },

    onAdjust: function(e) {
        e && e.preventDefault();
        this.openPopup({
            text: this.model.get('phrase'),
            geo: this.bannerModel.get('geo'),
            tm: "", key: "", minus: 1,
            path: this.params.modelPath,
            // DIRECT-24473: Учет единых минус-слов на баннер в медиапланах
            'minus-words': BEM.blocks['i-utils']
                    .minusWordsStringToArray(this.bannerModel.getChildModel('b-minus-words').get('minus_words')).join(',')
        })
    },

    onSelect: function(e) {
        e && e.preventDefault();
        this.openPopup({
            text: this.model.get('phrase'),
            geo: this.bannerModel.get('geo'),
            tm: time, key: key, minus: '',
            path: this.params.bannerModelPath,
            'minus-words': ''
        })
    },

    onDelete: function(e) {
        e && e.preventDefault();
        iModelsManager.deleteModel(this.params.modelPath, this.__self.getName());
    },

    onModelDeleted: function() {
        this.afterCurrentEvent(function() {
            BEM.blocks['b-mediaplan-form-phrases-splited'].trigger('phrase-delete');
            this.destruct();
        });
    },

    openPopup: function(data) {
        var frm = this.getFormInstance();

        data.suffix = this.bannerModel.get('bid');

        $.each(['text', 'geo', 'tm', 'key', 'minus', 'path', 'suffix', 'minus-words'], function(i, field) {
            frm.elem(field).val(data[field])
        });

        //функция из main_js
        var win = create_standard_window("", "Words");
        frm.domElem.submit();
        if (navigator.appName == 'Netscape') {
            win.focus();
        }
    },

    getFormInstance: function() {
        if (this.__self.formInstance) { return this.__self.formInstance }
        $(document.body).append(BEM.HTML.build({block: 'b-mediaplan-form-phrase-form'}));
        return (this.__self.formInstance = $('#b-mediaplan-form-phrase-form').bem('b-mediaplan-form-phrase-form'))
    }
});

BEM.blocks['b-model'].register('b-mediaplan-form-phrase-splited', {
    fields: {
        'phrase': {type: 'string', fromServer: 1, toServer: 1, children: ['numword']},
        'id': {type: 'string'},
        'can_delete': {type: 'flag'},
        'numword': {type: 'string', calcValue: function() {
            var phrases = this.get('phrase').split(' '),
                phraseArray = [];

            for (var i = 0; i < phrases.length; i++) {
                if (!phrases[i].match(/^-.*/)) {
                    phraseArray.push(phrases[i]);
                }
            }
            return phraseArray.length;
        }}
    }
});


BEM.HTML.decl('b-mediaplan-form-phrase-form', {
    onBlock: function(ctx) {
        ctx
            .js(true)
            .tag('form')
            .attrs({'method': 'POST', 'target': 'Words', id: 'b-mediaplan-form-phrase-form'})
            .content([
                {tag: 'input', attrs: {name: 'cmd', type: 'hidden', value: 'wordstat'}},
                {tag: 'input', attrs: {name: 'text', type: 'hidden'}, elem: 'text'},
                {tag: 'input', attrs: {name: 'suffix', type: 'hidden'}, elem: 'suffix'},
                {tag: 'input', attrs: {name: 'key', type: 'hidden'}, elem: 'key'},
                {tag: 'input', attrs: {name: 'tm', type: 'hidden'}, elem: 'tm'},
                {tag: 'input', attrs: {name: 'geo', type: 'hidden'}, elem: 'geo'},
                {tag: 'input', attrs: {name: 'minus', type: 'hidden'}, elem: 'minus'},
                {tag: 'input', attrs: {name: 'path', type: 'hidden'}, elem: 'path'},
                {tag: 'input', attrs: {name: 'minus_words', type: 'hidden'}, elem: 'minus-words'}
            ])
    }
});

BEM.HTML.decl('b-mediaplan-form-phrase-splited', {
    onBlock: function(ctx) {
        ctx
            .js({'modelPath': ctx.param('path'), 'bannerModelPath': ctx.param('bannerPath')})
            .mods({'type': ctx.param('type')})
            .tag('table')
            .cls('b-mediaplan-form-phrase-splited b-pf__action-c b-banner-form__phrases-keywords')
            .content({
                tag: 'tbody',
                content: {
                    tag: 'tr',
                    content: [
                        {tag: 'td', attrs: {style: 'width: 15px; padding: 0.4em;'}, content: {elem: 'delete'}},
                        {tag: 'td', cls: 'b-pf__action__input-c b-pf__action__input_counter_yes', content: [
                            {elem: 'input', phrase: direct.utils.escapeHTML(ctx.param('phrase'))},
                            {elem: 'counter' }
                        ]},
                        {tag: 'td', cls: 'b-pf__action__action-c', content: {elem: 'adjust'}},
                        {tag: 'td', cls: 'b-pf__action__action-c', content: {elem: 'select'}}
                    ]
                }
            })
    },
    onElem: {
        'delete': function(ctx) {
            ctx
                .tag('a')
                .attrs({border: 0, href: '#'})
                .content({
                    tag: 'img',
                    attrs: {src: '/i/i-delete.gif', width: 13, height: 13, alt: iget('Удалить фразу')}
                })
        },
        'input': function(ctx) {
            ctx
                .tag('input')
                .attrs({type: 'text', value: ctx.param('phrase')})
                .cls('b-pf__input b-pf__action__input keyword-input')
                .content()
        },
        'counter': function(ctx) {
            ctx
                .tag('span')
                .cls('b-mediaplan-form-phrase-splited__counter')
                .content('...')
        },
        'adjust': function(ctx) {
            ctx
                .tag('a')
                .attrs({href: '#'})
                .content(iget('Уточнить'))
                .wrap({tag: 'span', cls: 'b-pf__action'})
        },
        'select': function(ctx) {
            ctx
                .tag('a')
                .attrs({href: '#'})
                .content(iget('Подобрать'))
                .wrap({tag: 'span', cls: 'b-pf__action'})
        }
    }
})

})(jQuery);
