(function($){
    var iModelsManager = BEM.blocks['i-models-manager'];

//групповые действия с фразами в медиаплане
BEM.DOM.decl('b-mediaplan-form-phrases-mass', {
    onSetMod: {
        'js': function(){
            var _this = this;

            this.dropdowna = this.findBlockInside('b-dropdowna');

            this.modelName = 'b-mediaplan-form-phrase-splited';
            this.modelsPath = 'campaign&banner:' + this.params.bid + '&type:*&phrase:*';
            this.actionLinks = $.map(this.elem('action'), function(elem) {
                return _this.findBlockInside($(elem), 'b-pseudo-link')
                    .on('click', _this.doAction, _this);
            });
        }
    },

    /**
     * Выполняет групповое действие
     * @param e {Object} - событие клика по псевдоссылке
     * @returns {BEM}
     */
    doAction: function(e) {
        var action = e.block.params.action,
            minusWordExp = /\s\-[+!]?[a-zа-яё0-9]/i,
            minusWordMatch,
            _this = this;

        if (action == 'delete_all')
            this.removeAllPhrases();
        else {
            iModelsManager.eachModel(function(i, model) {
                var phrase = model.get('phrase');

                switch (action) {
                    case 'to_upper_case':
                    case 'to_lower_case':
                        phrase = _this.changeCase(phrase, action.substr(3,5));
                        break;

                    case 'wrap_quotes':
                    case 'unwrap_quotes':
                        //Ставим/снимаем кавычки только для фраз без минус-слов (#DIRECT-18906)
                        minusWordMatch = phrase.match(minusWordExp);
                        if (!minusWordMatch)
                            phrase = _this.wrapQuotes(phrase, action.substr(0,2) != 'un');
                        break;
                }

                model.set('phrase', phrase);

            }, this.modelsPath, this.modelName);
        }

        this.dropdowna.getPopup().hide();

        return this;
    },

    /**
     * Изменяет регистр первого символа в строке
     * @param str {String} - строка, которую необходимо обработать
     * @param caseLetter {'upper'|'lower'} - в какой регистр необходимо перевести первый симыол
     * @returns {String}
     */
    changeCase: function(str, caseLetter) {
        var strMatch = str.match(/^[^а-яА-ЯёЁa-zA-Z0-9]*([а-яА-ЯёЁa-zA-Z0-9])/), //из-за оперы #DIRECT-19184
            firstLetterPos;

        if (strMatch) {
            firstLetterPos = str.indexOf(strMatch[1]) + 1;

            str = (caseLetter == 'lower'
                ? str.substr(0, firstLetterPos).toLocaleLowerCase()
                : str.substr(0, firstLetterPos).toLocaleUpperCase())
                + str.substr(firstLetterPos, str.length - firstLetterPos);
        }

        return str;
    },


    /**
     *
     * @param str {String}
     * @param f {Boolean} Флаг обработки. 1 - ставим кавычки, 0 - убираем
     * @returns {String}
     */
    wrapQuotes: function(str, f) {
        var quotesExp = /['"]/,
            length = str.length;

        if (quotesExp.test(str.substr(0,1)) && quotesExp.test(str.substr(length - 1, 1))) {
            if (!f)
                str = str.substr(1, length - 2);
        }
        else {
            if (f)
                str = '"' + str + '"';
        }

        return str;
    },

    /**
     * Удаляет все разбитые фразы в медиаплане
     * @returns {BEM}
     */
    removeAllPhrases: function() {
        var _this = this;

        iModelsManager.eachModel(function(i, model) {
            iModelsManager.deleteModel(model.path(), _this.modelName)
        }, this.modelsPath, this.modelName);

        return this;
    }

});

})(jQuery);